@extends('admin.layouts.app')
@section('page_title', __('Plan Invest History'))

@section('content')
<div class="content container-fluid bg-light">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item"><a class="breadcrumb-link" href="javascript:void(0);">@lang('Dashboard')</a></li>
                        <li class="breadcrumb-item active" aria-current="page">@lang('Plan Invest History')</li>
                    </ol>
                </nav>
                <h1 class="page-header-title">@lang('Plan Invest History')</h1>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header card-header-content-md-between">
            <div class="row w-100 g-2">
                <div class="col-md-4">
                    <div class="input-group input-group-merge navbar-input-group">
                        <div class="input-group-prepend input-group-text">
                            <i class="bi-search"></i>
                        </div>
                        <input type="search" id="datatableSearch" class="search form-control form-control-sm"
                               placeholder="@lang('Search history')" aria-label="@lang('Search history')" autocomplete="off">
                        <a class="input-group-append input-group-text display-none" href="javascript:void(0)">
                            <i id="clearSearchResultsIcon" class="bi-x"></i>
                        </a>
                    </div>
                </div>
                <div class="col-md-4">
                    <input type="text" id="dateFilter" class="form-control js-flatpickr" placeholder="@lang('Select Date Range')"
                           data-date-format="Y-m-d" data-mode="range" autocomplete="off">
                </div>
            </div>
        </div>

        <div class="table-responsive datatable-custom invest-plan-history">
            <table id="datatable"
                   class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                   data-hs-datatables-options='{
                       "columnDefs": [{"targets": [0, 4],"orderable": false}],
                       "order": [],
                       "info": {"totalQty": "#datatableWithPaginationInfoTotalQty"},
                       "search": "#datatableSearch",
                       "entries": "#datatableEntries",
                       "pageLength": 15,
                       "isResponsive": false,
                       "isShowPaging": false,
                       "pagination": "datatablePagination"
                   }'>
                <thead class="thead-light">
                <tr>
                    <th>@lang('Transaction Id')</th>
                    <th>@lang('Name')</th>
                    <th>@lang('Plan')</th>
                    <th>@lang('Created At')</th>
                    <th>@lang('Action')</th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>

        <div class="card-footer">
            <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                        <span class="me-2">@lang('Showing:')</span>
                        <div class="tom-select-custom">
                            <select id="datatableEntries"
                                    class="js-select form-select form-select-borderless w-auto" autocomplete="off"
                                    data-hs-tom-select-options='{"searchInDropdown": false, "hideSearch": true}'>
                                <option value="10">10</option>
                                <option value="20" selected>20</option>
                                <option value="30">30</option>
                                <option value="40">40</option>
                            </select>
                        </div>
                        <span class="text-secondary me-2">@lang('of')</span>
                        <span id="datatableWithPaginationInfoTotalQty"></span>
                    </div>
                </div>
                <div class="col-sm-auto">
                    <div class="d-flex justify-content-center justify-content-sm-end">
                        <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="InvestTerminateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLabel">@lang('Confirmation')?</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="terminateRoute" method="post">
                @csrf
                <div class="modal-body">
                    <p>@lang('Are you sure you want to terminate this investment')?</p>
                    <p>@lang('Terminate Charge is') {{ basicControl()->terminate_charge }}%. 
                    @lang('If you want to change terminate charge then') 
                    <a href="{{ route('admin.basic.control') }}">@lang('click here')</a></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">@lang('Confirm')</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('css-lib')
<link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">
<link rel="stylesheet" href="{{ asset('assets/admin/css/flatpickr.min.css') }}">
@endpush

@push('js-lib')
<script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/flatpickr.min.js') }}"></script>
@endpush

@push('script')
<script>
$(document).on('click', '.terminate_btn', function () {
    $('#terminateRoute').attr('action', $(this).data('route'))
});

$(document).ready(function () {
    // Init flatpickr manually with custom rangeSeparator
    flatpickr("#dateFilter", {
        mode: "range",
        dateFormat: "Y-m-d",
        locale: {
            rangeSeparator: " to "
        }
    });

    HSCore.components.HSTomSelect.init('.js-select', { maxOptions: 250 });

    let table = HSCore.components.HSDatatables.init($('#datatable'), {
        processing: true,
        serverSide: true,
        ordering: false,
        ajax: {
            url: "{{ route('admin.invest.history.list') }}",
            data: function (d) {
                d.date = $('#dateFilter').val(); // Send the flatpickr date range string
            }
        },
        columns: [
            { data: 'trx_id', name: 'trx_id' },
            { data: 'name', name: 'name' },
            { data: 'plan', name: 'plan' },
            { data: 'created_at', name: 'created_at' },
            { data: 'action', name: 'action' },
        ],
        language: {
            zeroRecords: `<div class="text-center p-4">
                            <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error.svg') }}" alt="Image" data-hs-theme-appearance="default">
                            <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="Image" data-hs-theme-appearance="dark">
                            <p class="mb-0">No data to show</p>
                          </div>`,
            processing: `<div><div></div><div></div><div></div><div></div></div>`
        }
    });

    // Reload table on date range change
    $('#dateFilter').on('change', function () {
        $('#datatable').DataTable().ajax.reload();
    });

    $.fn.dataTable.ext.errMode = 'throw';
});
</script>
@endpush
