@extends('admin.layouts.login')
@section('page_title', __('Verify Code'))

@section('content')
    <div class="card card-lg mt-lg-5">
        <div class="card-body">
            @if(Session::has('status'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <span class="fw-semibold">{{ Session::get('status') }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <span class="fw-semibold">{{ $errors->first() }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <form method="POST" action="{{ route('admin.monthly.verify.code') }}" class="js-validate needs-validation" novalidate>
                @csrf
                <div class="text-center">
                    <div class="mb-5">
                        <h1 class="display-5">@lang('Verify Code')</h1>
                        <p class="text-muted">@lang('Enter the 6-digit code sent to your email.')</p>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label" for="verify_code">@lang('Verification Code')</label>
                    <input type="text"
                           class="form-control form-control-lg @error('verify_code') is-invalid @enderror"
                           name="verify_code"
                           id="verify_code"
                           placeholder="Enter 6-digit code"
                           required>
                    @error('verify_code')
                    <span class="invalid-feedback d-block">{{ $message }}</span>
                    @enderror
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary btn-lg">@lang('Verify')</button>
                </div>
            </form>
            <form method="POST" action="{{ route('admin.monthly.verify.resend') }}">
                @csrf
                <div class="d-grid">
                    <button type="submit" class="btn btn-link">Resend Code</button>
                </div>
            </form>
        </div>
    </div>
@endsection
