@extends('admin.layouts.app')
@section('page_title', __('Summary'))
@section('content')
<div class="content container-fluid">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title">@lang("Summary")</h1>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header card-header-content-md-between">
                    <div class="mb-2 mb-md-0">
                        <div class="input-group input-group-merge navbar-input-group">
                            <div class="input-group-prepend input-group-text">
                                <i class="bi-search"></i>
                            </div>
                            <input type="search" id="datatableSearch"
                            class="search form-control form-control-sm"
                            placeholder="@lang('Search Records')"
                            aria-label="@lang('Search Records')"
                            autocomplete="off">
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-responsive datatable-custom" style="overflow-x: auto;">
                <table id="datatable"
                    class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                    data-hs-datatables-options='{
                        "columnDefs": [{
                            "targets": [9],
                            "orderable": false
                        }],
                        "order": [],
                        "info": {
                            "totalQty": "#datatableWithPaginationInfoTotalQty"
                        },
                        "search": "#datatableSearch",
                        "entries": "#datatableEntries",
                        "pageLength": 10,
                        "isResponsive": false,
                        "isShowPaging": false,
                        "pagination": "datatablePagination"
                    }'>
                    <thead class="thead-light">
                        <tr>
                            <th>@lang('Customer ID')</th>
                            <th>@lang('Customer Name')</th>
                            <th>@lang('Total Machines')</th>
                            <th>@lang('Days Invested')</th>
                            <th>@lang('Hashrate')</th>
                            <th>@lang('Mining Reward')</th>
                            <th>@lang('Commission Reward')</th>
                            <th>@lang('Total Reward')</th>
                            <th>@lang('Status')</th>
                            <th>@lang('Action')</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>

            <div class="card-footer">
                <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                    <div class="col-sm mb-2 mb-sm-0">
                        <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                            <span class="me-2">@lang('Showing:')</span>
                            <div class="tom-select-custom">
                                <select id="datatableEntries"
                                    class="js-select form-select form-select-borderless w-auto"
                                    autocomplete="off"
                                    data-hs-tom-select-options='{
                                        "searchInDropdown": false,
                                        "hideSearch": true
                                    }'>
                                    <option value="5">5</option>
                                    <option value="10" selected>10</option>
                                    <option value="15">15</option>
                                    <option value="20">20</option>
                                </select>
                            </div>
                            <span class="text-secondary me-2">@lang('of')</span>
                            <span id="datatableWithPaginationInfoTotalQty"></span>
                        </div>
                    </div>

                    <div class="col-sm-auto">
                        <div class="d-flex justify-content-center justify-content-sm-end">
                            <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
</div>
@include('admin.user_management.components.multiple_user_approve_modal')
@endsection

@push('css-lib')
<link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">
@endpush

@push('js-lib')
<script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/select.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/appear.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/hs-counter.min.js') }}"></script>
@endpush

@push('script')
<script>
    $(document).on('ready', function () {
        var parentId = "{{ request()->route('id') }}";

        HSCore.components.HSDatatables.init($('#datatable'), {
            processing: true,
            serverSide: true,
            ordering: false,
            ajax: {
                url: "{{ route('admin.monthly.plan.listsummary') }}",
                data: function (d) {
                    d.id = parentId;
                }
            },
            columns: [
                {data: 'user_id', name: 'user_id'},
                {data: 'name', name: 'name'},
                {data: 'total_machines', name: 'total_machines'},
                {data: 'days_invested', name: 'days_invested'},
                {data: 'hashrate', name: 'hashrate'},
                {data: 'mining_reward', name: 'mining_reward'},
                {data: 'commission_reward', name: 'commission_reward'},
                {data: 'total_reward', name: 'total_reward'},
                {data: 'status', name: 'status', orderable: false, searchable: false },
                {data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            language: {
                zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error.svg') }}" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data found for the given criteria.</p>
                </div>`,
                processing: `<div><div></div><div></div><div></div><div></div></div>`
            },
        });
    });

    $.fn.dataTable.ext.errMode = 'throw';

    $(document).on('click', '.loginAccount', function () {
        let route = $(this).data('route');
        $('.loginAccountAction').attr('action', route)
    });
</script>
@endpush
