@extends('admin.layouts.app')
@section('page_title', __('Overview'))
@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title">@lang('Mining Reward')</h1>
            </div>
            <div class="col-sm-auto">
                <a href="{{ route('admin.monthly.plan.index') }}" class="btn btn-primary">@lang('Back to List')</a>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <div class="row">
        <div class="col-lg-12">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title">@lang('Mining Reward')</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive" style="overflow-x: auto;">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>@lang('Customer ID')</th>
                                    <th>@lang('Customer Name')</th>
                                    <th>@lang('Plan')</th>
                                    <th>@lang('Quantity')</th>
                                    <th>@lang('Purchased At')</th>
                                    <th>@lang('Start Date')</th>
                                    <th>@lang('End Date')</th>
                                    <th>@lang('Days Vested')</th>
                                    <th>@lang('Hash Rate')</th>
                                    <th>@lang('Mining Reward')</th>
                                    <th>@lang('Status')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($processedInvestments as $investment)
                                <tr>
                                    <td>{{ $investment['user_id'] }}</td>
                                    <td>{{ $investment['user_name'] }}</td>
                                    <td>
                                        @php
                                        $plan = \App\Models\InvestmentPlan::find($investment['planId']);
                                        @endphp
                                        {{ $plan->plan_name ?? 'N/A' }}
                                    </td>                                   
                                    <td>{{ $investment['quantity'] }}</td>
                                    <td>{{ $investment['purchased_date'] }}</td>
                                    <td>{{ $investment['effective_start_date'] }}</td>
                                    <td>{{ $investment['effective_end_date'] }}</td>
                                    <td>{{ $investment['days_invested'] }}</td>
                                    <td>{{ $investment['hashrate'] }}</td>
                                    <td>{{ $investment['calculated_reward'] }}</td>
                                    <td>Pending</td>
                                </tr>
                                @endforeach
                            </tbody>
<!--                             <tfoot>
                                <tr class="table-primary">
                                    <th style="background: #3F51B5 !important;color: #ffffff;"  colspan="3">@lang('Total')</th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;" >{{ $summary['total_quantity'] }}</th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;"  colspan="4"></th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;" >{{ $summary['total_reward'] }}</th>
                                </tr>
                            </tfoot> -->
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection