@extends('admin.layouts.app')
@section('page_title', __('Monthly Plans'))
@section('content')
<div class="content container-fluid bg-light">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item"><a class="breadcrumb-link" href="javascript:void(0)">@lang("Dashboard")</a></li>
                        <li class="breadcrumb-item active" aria-current="page">@lang("Monthly Revenue")</li>
                    </ol>
                </nav>
                <h1 class="page-header-title">@lang("Monthly Revenue")</h1>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header card-header-content-md-between">
                    <div class="mb-2 mb-md-0">
                        <div class="input-group input-group-merge navbar-input-group">
                            <div class="input-group-prepend input-group-text">
                                <i class="bi-search"></i>
                            </div>
                            <input type="search" id="datatableSearch"
                            class="search form-control form-control-sm"
                            placeholder="@lang('Search Records')"
                            aria-label="@lang('Search Records')"
                            autocomplete="off">
                        </div>
                    </div>

                    <div class="d-grid d-sm-flex justify-content-md-end align-items-sm-center gap-2">
                        <a href="{{ route('admin.monthly.plan.create') }}" class="btn btn-primary">@lang('Create Month Revenue')</a>
                    </div>
                </div>

                <div class="table-responsive datatable-custom" style="overflow-x: auto;">
                    <table id="datatable"
                    class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                    data-hs-datatables-options='{
                       "columnDefs": [{
                          "targets": [6],
                          "orderable": false
                      }],
                      "order": [],
                      "info": {
                         "totalQty": "#datatableWithPaginationInfoTotalQty"
                     },
                     "search": "#datatableSearch",
                     "entries": "#datatableEntries",
                     "pageLength": 10,
                     "isShowPaging": false,
                     "pagination": "datatablePagination"
                 }'>
                 <thead class="thead-light">
                    <tr>
                        <th>@lang('ID')</th>
                        <th>@lang('Period Start')</th>
                        <th>@lang('Period End')</th>
                        <th>@lang('Operations Cost')</th>
                        <th>@lang('Operation Percentage (%)')</th>
                        <th>@lang('Total Machine')</th>
                        <th>@lang('Total Reward')</th>
                        <th>@lang('Created At')</th>
                        <th>@lang('Status')</th>
                        <th>@lang('Action')</th>
                    </tr>
                </thead>

                <tbody></tbody>
            </table>
        </div>

        <div class="card-footer">
            <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                        <span class="me-2">@lang('Showing:')</span>
                        <div class="tom-select-custom">
                            <select id="datatableEntries"
                            class="js-select form-select form-select-borderless w-auto"
                            autocomplete="off"
                            data-hs-tom-select-options='{
                                "searchInDropdown": false,
                                "hideSearch": true
                            }'>
                            <option value="5">5</option>
                            <option value="10" selected>10</option>
                            <option value="15">15</option>
                            <option value="20">20</option>
                        </select>
                    </div>
                    <span class="text-secondary me-2">@lang('of')</span>
                    <span id="datatableWithPaginationInfoTotalQty"></span>
                </div>
            </div>

            <div class="col-sm-auto">
                <div class="d-flex justify-content-center justify-content-sm-end">
                    <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" data-bs-backdrop="static"
aria-hidden="true">
<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="deleteModalLabel"><i
                class="bi bi-check2-square"></i> @lang("Confirmation")</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="" method="post" class="setRoute">
                @csrf
                @method("delete")
                <div class="modal-body">
                    <p>@lang("Do you want to delete this record?")</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal">@lang('Close')</button>
                    <button type="submit" class="btn btn-primary">@lang('Confirm')</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('css-lib')
<link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">
@endpush

@push('js-lib')
<script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/select.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/appear.min.js') }}"></script>
<script src="{{ asset("assets/admin/js/hs-counter.min.js") }}"></script>
@endpush

@push('script')
<script>
    $(document).on('ready', function () {
        $(document).on('click', '.deleteBtn', function () {
            let route = $(this).data('route');
            $('.setRoute').attr('action', route);
        });

        new HSCounter('.js-counter');
        HSCore.components.HSTomSelect.init('.js-select', {
            maxOptions: 250,
        });
        
        HSCore.components.HSDatatables.init($('#datatable'), {
            processing: true,
            serverSide: true,
            ordering: false,
            ajax: {
                url: "{{ route("admin.monthly.plan.list") }}",
            },
            columns: [
                {data: 'id', name: 'id'},
                {data: 'period_start', name: 'period_start'},
                {data: 'period_end', name: 'period_end'},
                {data: 'cost', name: 'cost'},
                {data: 'operation_percentage', name: 'operation_percentage'},
                {data: 'total_machine', name: 'total_machine'},
                {data: 'reward', name: 'reward'},
                {data: 'created_at', name: 'created_at'},
                { data: 'status', name: 'status', orderable: false, searchable: false },
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ],
            language: {
                zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error.svg') }}" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data to show</p>
                </div>`,
                processing: `<div><div></div><div></div><div></div><div></div></div>`
            },
        });
    });
</script>
@endpush