@extends('admin.layouts.app')
@section('page_title', __('Create Configuration'))
@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title">@lang('Create Monthly Plan')</h1>
            </div>
            <div class="col-sm-auto">
                <a href="{{ route('admin.monthly.plan.index') }}" class="btn btn-primary">@lang('Back to List')</a>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <form action="{{ route('admin.monthly.plan.store') }}" method="post">
        @csrf
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title">@lang('Monthly Plan Configuration')</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Period Start -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="period_start" class="form-label">@lang('Period Start')</label>
                                    <input type="date" 
                                    class="form-control @error('period_start') is-invalid @enderror" 
                                    name="period_start" 
                                    id="period_start" 
                                    value="{{ old('period_start') }}"
                                    required>
                                    @error('period_start')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Period End -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="period_end" class="form-label">@lang('Period End')</label>
                                    <input type="date" 
                                    class="form-control @error('period_end') is-invalid @enderror" 
                                    name="period_end" 
                                    id="period_end" 
                                    value="{{ old('period_end') }}"
                                    required>
                                    @error('period_end')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>


                            <!-- Reward -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="reward" class="form-label">@lang('Total Reward')</label>
                                    <input type="number" 
                                    class="form-control @error('reward') is-invalid @enderror" 
                                    name="reward" 
                                    id="reward" 
                                    value="{{ old('reward') }}"
                                    step="0.0001"
                                    min="0"
                                    required>
                                    @error('reward')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>     

                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="cost" class="form-label">@lang('Operations Cost')</label>
                                    <input type="number" 
                                    class="form-control @error('cost') is-invalid @enderror" 
                                    name="cost" 
                                    id="cost" 
                                    value="{{ old('cost') }}"
                                    step="0.0001"
                                    min="0"
                                    required>
                                    @error('cost')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="operation_percentage" class="form-label">Operation Percentage</label>
                                    <input type="number" 
                                    class="form-control @error('operation_percentage') is-invalid @enderror" 
                                    name="operation_percentage" 
                                    id="operation_percentage" 
                                    value="{{ old('operation_percentage') }}"
                                    step="1"
                                    min="0"
                                    required>
                                    @error('operation_percentage')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="total_machine" class="form-label">Total Machine</label>
                                    <input type="number" 
                                    class="form-control @error('total_machine') is-invalid @enderror" 
                                    name="total_machine" 
                                    id="total_machine" 
                                    value="{{ old('total_machine') }}"
                                    step="1"
                                    min="0"
                                    required>
                                    @error('total_machine')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title">@lang('Actions')</h4>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-3">
                            <button type="submit" class="btn btn-primary">@lang('Save')</button>
                            <button type="reset" class="btn btn-secondary">@lang('Reset')</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('script')
<script>
    $(document).ready(function() {
        // Date validation to ensure period_end is after period_start
        $('#period_start, #period_end').change(function() {
            const startDate = new Date($('#period_start').val());
            const endDate = new Date($('#period_end').val());
            
            if (startDate && endDate && endDate <= startDate) {
                alert('Period End must be after Period Start');
                $('#period_end').val('');
            }
        });
    });
</script>
@endpush