@extends('admin.layouts.app')

@section('page_title', __('Content Settings'))

@section('content')
<div class="content container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex justify-content-between align-items-center">
        <div>
            <h1 class="page-header-title">@lang('Content Settings')</h1>
        </div>
        <div>
            <a href="{{ route('admin.contentsetting.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> @lang('Create New')
            </a>
        </div>
    </div>

    <!-- Content Settings Table -->
    <div class="card mt-3">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-striped mb-0">
                    <thead class="table-light">
                        <tr>
                            <th scope="col">@lang('ID')</th>
                            <th scope="col">@lang('Subject')</th>
                            <th scope="col">@lang('Type')</th>
                            <th scope="col">@lang('Created At')</th>
                            <th scope="col">@lang('Actions')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($contentSettings as $setting)
                            <tr>
                                <td>{{ $setting->id }}</td>
                                <td>{{ Str::limit($setting->subject, 50) }}</td>
                                <td>{{ Str::title(str_replace('_', ' ', $setting->type)) }}</td>
                                <td>{{ $setting->created_at->format('Y-m-d') }}</td>
                                <td>
                                    <a href="{{ route('admin.contentsetting.edit', $setting->id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-pencil-square"></i> @lang('Edit')
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted">@lang('No content settings found.')</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
@endsection
