@extends('admin.layouts.app')

@section('page_title', __('Create Content'))

@push('css-lib')
<link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">
@endpush

@section('content')
<div class="content container-fluid">
    <div class="page-header">
        <h1 class="page-header-title">@lang('Create Content')</h1>
    </div>

    <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
    <style>
        .ck-editor__editable { min-height: 400px; }
        .ck.ck-editor { box-shadow: 0 0 0 1px var(--ck-color-base-border); }
        .ck.ck-toolbar {
            border: 1px solid #dee2e6;
            border-bottom: 0;
            border-radius: 0.375rem 0.375rem 0 0;
        }
        .ck.ck-editor__main>.ck-editor__editable {
            border: 1px solid #dee2e6;
            border-top: 0;
            border-radius: 0 0 0.375rem 0.375rem;
        }
    </style>

    <div class="row d-flex justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.contentsetting.store') }}" id="editor-form">
                        @csrf

                        <div class="form-group mb-3">
                            <label for="subject">@lang('Subject')</label>
                            <input type="text" class="form-control" name="subject" id="subject" value="{{ old('subject') }}">
                        </div>

                        <div class="form-group mb-3">
                            <label for="type">@lang('Type')</label>
                            <select class="form-control" name="type" id="type">
                                <option value="contract_and_agreement">@lang('Contract and Agreement')</option>
                                <option value="register_contract_and_agreement">@lang('Register Contract and Agreement')</option>
                            </select>
                        </div>

                        <div id="editor">{!! old('content') !!}</div>
                        <textarea name="content" id="hidden-content" class="d-none"></textarea>

                        <br>
                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary mt-2">@lang('Create')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let editor;
    ClassicEditor.create(document.querySelector('#editor'), {
        toolbar: {
            items: ['heading', '|', 'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|', 'undo', 'redo']
        },
        heading: {
            options: [
                { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' }
            ]
        }
    }).then(editorInstance => {
        editor = editorInstance;
        document.getElementById('hidden-content').value = editor.getData();
        editor.model.document.on('change:data', () => {
            document.getElementById('hidden-content').value = editor.getData();
        });
    });

    document.getElementById('editor-form').addEventListener('submit', function() {
        if (editor) {
            document.getElementById('hidden-content').value = editor.getData();
        }
    });
});
</script>
@endsection

@push('js-lib')
<script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>
@endpush
