@extends('admin.layouts.app')
@section('page_title',__('Referral Commission'))
@section('content')
<div class="content container-fluid">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item"><a class="breadcrumb-link"
                         href="javascript:void(0);">@lang('Dashboard')</a></li>
                         <li class="breadcrumb-item active" aria-current="page">@lang('Referral Commission')</li>
                     </ol>
                 </nav>
                 <h1 class="page-header-title">@lang('Referral Commission')</h1>
             </div>
         </div>
     </div>
     <div class="row d-flex justify-content-center">
        <div class="col-md-5">
            <div class="card-header">
                <h5 class="card-header-title">@lang('Referral Levels Bonus')</h5>
            </div>
            <div class="card-body">
                <div class="container">
                    <form action="{{route('admin.registration.bonus.update')}}" method="post">
                        @csrf

                        <div class="row mb-4">
                            <div class="col-sm-12">
                                <label for="referral_level_1" class="form-label">@lang('Referral Level 1')</label>
                                <div class="input-group">
                                    <input type="number"
                                    class="form-control @error('referral_level_1') is-invalid @enderror"
                                    name="referral_level_1"
                                    id="referral_level_1" autocomplete="off"
                                    placeholder="@lang('Enter bonus for level 1')"
                                    value="{{ old('referral_level_1', $referrals[1]->commission ?? '') }}"
                                    step="0.01">
                                    <span class="input-group-text">%</span>
                                </div>
                                @error('referral_level_1')
                                <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-sm-12">
                                <label for="referral_level_2" class="form-label">@lang('Referral Level 2')</label>
                                <div class="input-group">
                                    <input type="number"
                                    class="form-control @error('referral_level_2') is-invalid @enderror"
                                    name="referral_level_2"
                                    id="referral_level_2" autocomplete="off"
                                    placeholder="@lang('Enter bonus for level 2')"
                                    value="{{ old('referral_level_2', $referrals[2]->commission ?? '') }}"
                                    step="0.01">
                                    <span class="input-group-text">%</span>
                                </div>
                                @error('referral_level_2')
                                <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-sm-12">
                                <label for="referral_level_3" class="form-label">@lang('Referral Level 3')</label>
                                <div class="input-group">
                                    <input type="number"
                                    class="form-control @error('referral_level_3') is-invalid @enderror"
                                    name="referral_level_3"
                                    id="referral_level_3" autocomplete="off"
                                    placeholder="@lang('Enter bonus for level 3')"
                                    value="{{ old('referral_level_3', $referrals[3]->commission ?? '') }}"
                                    step="0.01">
                                    <span class="input-group-text">%</span>
                                </div>
                                @error('referral_level_3')
                                <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>


                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary mt-2">@lang('Save Changes')</button>
                        </div>
                    </form>
                </div>
            </div>

        </div>

    </div>
</div>
@endsection

@push('css-lib')
<link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">
@endpush

@push('js-lib')
<script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>
@endpush
