@extends('admin.layouts.app')
@section('page_title', __('Create Admin'))
@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title">@lang('Create Admin')</h1>
            </div>
            <div class="col-sm-auto">
                <a href="{{ route('admin.admins.index') }}" class="btn btn-primary">@lang('Back to List')</a>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <form action="{{ route('admin.admins.store') }}" method="post">
        @csrf
        <div class="row">
            <!-- Left Column -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title">@lang('Admin Information')</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Name -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="name" class="form-label">@lang('Name')</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    name="name" id="name" value="{{ old('name') }}" required>
                                    @error('name')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Username -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="username" class="form-label">@lang('Username')</label>
                                    <input type="text" class="form-control @error('username') is-invalid @enderror"
                                    name="username" id="username" value="{{ old('username') }}" required>
                                    @error('username')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="email" class="form-label">@lang('Email')</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                    name="email" id="email" value="{{ old('email') }}" required>
                                    @error('email')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="status" class="form-label">@lang('Status')</label>
                                    <select name="status" id="status"
                                    class="form-select @error('status') is-invalid @enderror" required>
                                    <option value="1" {{ old('status') == '1' ? 'selected' : '' }}>@lang('Active')</option>
                                    <option value="0" {{ old('status') == '0' ? 'selected' : '' }}>@lang('Inactive')</option>
                                </select>
                                @error('status')
                                <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Password -->
                        <div class="col-md-6">
                            <div class="mb-4">
                                <label for="password" class="form-label">@lang('Password')</label>
                                <input type="password" class="form-control @error('password') is-invalid @enderror"
                                name="password" id="password" required>
                                @error('password')
                                <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="col-md-6">
                            <div class="mb-4">
                                <label for="password_confirmation" class="form-label">@lang('Confirm Password')</label>
                                <input type="password" class="form-control @error('password_confirmation') is-invalid @enderror"
                                name="password_confirmation" id="password_confirmation" required>
                                @error('password_confirmation')
                                <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>                            

                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-header-title">@lang('Actions')</h4>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-3">
                        <button type="submit" class="btn btn-primary">@lang('Create Admin')</button>
                        <button type="reset" class="btn btn-secondary">@lang('Reset')</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
</div>
@endsection
