<?php



namespace App\Http\Controllers\User;





use App\Helpers\GoogleAuthenticator;

use App\Http\Controllers\Controller;

use App\Jobs\DistributeBonus;

use App\Models\Deposit;
use App\Models\ContentSetting;

use App\Models\Gateway;

use App\Models\InvestHistory;

use App\Models\InvestmentPlan;
use App\Models\User;

use App\Models\Kyc;

use App\Models\Language;
use App\Models\Wallet;
use App\Models\Referral;

use App\Models\Order;

use App\Models\OrderItems;

use App\Models\Payout;

use App\Models\Ranking;

use App\Models\ReferralBonus;

use App\Models\SupportTicket;

use App\Models\Transaction;

use App\Models\UserKyc;
use App\Models\MonthlyConfig;
use App\Models\GeneralConfig;

use App\Models\WishList;

use App\Rules\PhoneLength;

use App\Traits\Upload;

use Illuminate\Http\Request;

use Illuminate\Support\Carbon;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Validator;

use Illuminate\Validation\Rule;

use Illuminate\Support\Facades\Hash;

use Facades\App\Services\BasicService;

use Illuminate\Support\Facades\DB;





class HomeController extends Controller

{

    use Upload;



    public function __construct()

    {

        $this->middleware(['auth']);

        $this->middleware(function ($request, $next) {

            $this->user = auth()->user();

            return $next($request);

        });

        $this->theme = template();

    }



    public function saveToken(Request $request)

    {

        try {

            Auth::user()

            ->fireBaseToken()

            ->create([

                'token' => $request->token,

            ]);

            return response()->json([

                'msg' => 'token saved successfully.',

            ]);

        } catch (\Exception $exception) {

            return back()->with('error', $exception->getMessage());

        }

    }

    private function getHashrateForPeriod($quantity)
    {
        $today = now()->toDateString();

        $general = GeneralConfig::where('period_start', '<=', $today)
        ->where('period_end', '>=', $today)
        ->first();

        if (!$general) {
            return "0 TH/s";
        }

        $each_hashrate = $general->total_hashrate / $general->total_machine;
        $user_hashrate = $each_hashrate * $quantity;

        return number_format($user_hashrate,2) . " TH/s";
    }    

    private function getCoinGenerated($quantity)
    {
        $today = now()->toDateString();

        $general = GeneralConfig::where('period_start', '<=', $today)
        ->where('period_end', '>=', $today)
        ->first();

        if (!$general) {
            return 0;
        }

        $each_hashrate = $general->total_coin_generated /  $general->total_machine;
        $user_hashrate = $each_hashrate * $quantity;

        return $user_hashrate;
    }

    private function getTotalMachinesDuringPeriod($period_end)
    {
        return DB::table('invest_histories')
        ->whereDate('created_at', '<=', $period_end)
        ->whereDate('plan_expiry_date', '>=', $period_end)
        ->sum('quantity');
    }
    private function getTotalMachinesDuringPeriodPerUser($period_end,$user_id)
    {
        return DB::table('invest_histories')
        ->where('user_id',$user_id)
        ->whereDate('created_at', '<=', $period_end)
        ->whereDate('plan_expiry_date', '>=', $period_end)
        ->sum('quantity');
    }
    private function calculateRewards($config, $start, $end)
    {
        $total_days = $start->diffInDays($end) + 1;
        $reward = (float) $config->reward;
        $cost = (float) $config->cost;
        $operation_percentage = $config->operation_percentage;
        $total_machines = $config->total_machine;
        $gross_reward=$reward - $cost;
        $after_gross = $gross_reward - ($gross_reward * ($operation_percentage / 100));

        $full_reward=$gross_reward / ($total_machines * $total_days);
        $sub_reward=$after_gross / ($total_machines * $total_days);

        return [
            'reward_per_day'     => $full_reward,
            'sub_reward_per_day'     => $sub_reward,
        ];
    }

    public function forceInvestment(Request $request)
    {
      $userId = Auth::id();
      $planId = $request->input('plan_id');
      $amount = $request->input('amount');
      $user = \App\Models\User::findOrFail($userId);
      $plan = \App\Models\InvestmentPlan::findOrFail($planId);

    $profit = $plan->Profit($amount); // Calculate expected profit
    $investment = BasicService::makeInvest($user, $plan, $profit, null, $amount);

    if ($investment) {
        $transactionType = \App\Models\InvestmentPlan::class;
        $transaction =BasicService::makeTransaction(
            $user,
            $amount,
            0,
            '-',
            $investment->trx,
            'Forced Investment (no balance check)',
            $transactionType,
            'profit'
        );

        $plan->transactional()->save($transaction);

        $user->total_invest += $amount;
        $user->save();

        return 'Investment success.';

    }

    return 'Investment failed.';
}
public function index()

{
         //This is the user data
    $data['user'] = Auth::user();
    $planInvestment = InvestHistory::with('plan')->where('user_id', Auth::id())->first();
    if(!$planInvestment){
        $hashrate='0 TH/s';
        $data['earning_cummulative'] = 0; 
        $data['earning_last_month'] = 0; 
        $data['referral_commision'] = 0; 
        $data['daily_coin_generated'] = 0; 
        $data['average_hashrate'] = $hashrate; 
        $chartData = [];

        $months = array_column($chartData, 'month');
        $miningData = array_column($chartData, 'mining_reward');
        $commissionData = array_column($chartData, 'commission_reward');

        $data['months'] = json_encode($months);
        $data['miningData'] = json_encode($miningData);
        $data['commissionData'] = json_encode($commissionData);
        $data['referral_code'] = optional(auth()->user())->referral_code;
        $data['agent_verify'] = optional(auth()->user())->agent_verify == 1 ? true : false;
        $data['insert_wallet'] = false;
        $data['transaction_allocation'] = [];
        $data['recent_transaction'] =[];
        $commissionSums = [
            'level1' => 0,
            'level2' => 0,
            'level3' => 0
        ];
        $today = now();

        $getConfig = \DB::table('monthly_configs')
        ->whereDate('period_start', '<=', $today)
        ->get();
        foreach ($getConfig as $config) {
            $referralReport = \Cache::get('referralReport_' . $config->id);
            
            if (!is_array($referralReport) || !isset($referralReport[Auth::id()])) {
                continue;
            }

            $referral = $referralReport[Auth::id()];

            foreach ($referral['level1'] as $level1) {
                $commissionSums['level1'] += $level1['commission'];

                foreach ($level1['level2'] as $level2) {
                    $commissionSums['level2'] += $level2['commission'];

                    foreach ($level2['level3'] as $level3) {
                        $commissionSums['level3'] += $level3['commission'];
                    }
                }
            }
        }

// Check downlines
        $data['lvl1'] = 0;
        $data['lvl1_total'] = number_format($commissionSums['level1'],4);
        $data['lvl1percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 1)->first())->commission ?? 0);

        $level1Users = getDirectReferralUsers(Auth::id());
        $data['lvl1'] = $level1Users->count();

// lvl2
        $level2Users = collect();
        foreach ($level1Users as $level1User) {
            $level2Users = $level2Users->merge(getDirectReferralUsers($level1User->id));
        }
        $data['lvl2'] = $level2Users->count();
        $data['lvl2_total'] = number_format($commissionSums['level2'],4);
        $data['lvl2percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 2)->first())->commission ?? 0);

// lvl3
        $level3Users = collect();
        foreach ($level2Users as $level2User) {
            $level3Users = $level3Users->merge(getDirectReferralUsers($level2User->id));
        }
        $data['lvl3'] = $level3Users->count();
        $data['lvl3_total'] = number_format($commissionSums['level3'],4);
        $data['lvl3percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 3)->first())->commission ?? 0);
        return view(template() . 'user.dashboard-alternative', $data);
    }

        //start calculation
    $today_date = now();
    $hashrate='0 TH/s';

    $purchased_at=$planInvestment->created_at;
    $cutoff_date = $purchased_at->copy()->addDay()->startOfDay();
    $show_data_on = $cutoff_date->copy()->addDay();

    $lastMonthDate = now()->subMonthNoOverflow()->startOfMonth();

    $userEarnLastMonth = \DB::table('summary')
    ->join('monthly_configs', 'summary.parent_id', '=', 'monthly_configs.id')
    ->select('summary.*', 'monthly_configs.*') 
    ->where('summary.user_id', Auth::id()) 
    ->whereDate('monthly_configs.period_start', '<=', $lastMonthDate)
    ->whereDate('monthly_configs.period_end', '>=', $lastMonthDate)
    ->first();
    if($userEarnLastMonth){
        $earning_last_month=$userEarnLastMonth->total_reward;
    }else{
        $earning_last_month=0;
    }
        //this is the earning stats
    $userEarn = \DB::table('summary')
    ->join('monthly_configs', 'summary.parent_id', '=', 'monthly_configs.id')
    ->select('summary.*', 'monthly_configs.*') 
    ->where('summary.user_id',Auth::id()) 
    ->whereDate('monthly_configs.period_start', '<=', $today_date)
    ->whereDate('monthly_configs.period_end', '>=', $today_date)
    ->first();
    if($userEarn){
        $config = MonthlyConfig::findOrFail($userEarn->parent_id);
        $period_start = Carbon::parse($config->period_start);
        $period_end = Carbon::parse($config->period_end);
        $result = $this->calculateRewards($config, $period_start, $period_end);
        $reward_per_day=$result['sub_reward_per_day'];
        $total_machines = $this->getTotalMachinesDuringPeriodPerUser($period_end,Auth::user()->id);
        $hashrate = $this->getHashrateForPeriod($total_machines,$config->total_machine);
        $coin_generated = $this->getCoinGenerated($total_machines,$config->total_machine);
        $data['earning_cummulative'] = $userEarn->total_reward; 
        $data['earning_last_month'] = $earning_last_month; 
        $data['referral_commision'] = $userEarn->commission_reward; 
        
        $now = now();
        if ($now->gte($cutoff_date->copy()->addDay())) {
            $data['daily_coin_generated'] = number_format($coin_generated,4); 
            $data['average_hashrate'] = $hashrate; 
        }else{
            $data['daily_coin_generated'] =0; 
            $data['average_hashrate'] = 0; 
        }

    }else{
        $data['earning_cummulative'] = 0; 
        $data['earning_last_month'] = 0; 
        $data['referral_commision'] = 0; 
        $data['daily_coin_generated'] = 0; 
        $data['average_hashrate'] = $hashrate; 
    }

    $userEarnChart = DB::table('summary')
    ->join('monthly_configs', 'summary.parent_id', '=', 'monthly_configs.id')
    ->select('summary.*', 'monthly_configs.*')
    ->where('summary.user_id', Auth::id())
    ->get();

    $chartData = [];

    if (!$userEarnChart->isEmpty()) {
        $chartData = $userEarnChart->map(function ($item) {
            return [
                'month' => Carbon::parse($item->period_start)->format('F'),
                'mining_reward' => (float) number_format($item->mining_reward, 4, '.', ''),
                'commission_reward' => (float) number_format($item->commission_reward, 4, '.', '')
            ];
        })->toArray();
    }

    $months = array_column($chartData, 'month');
    $miningData = array_column($chartData, 'mining_reward');
    $commissionData = array_column($chartData, 'commission_reward');

    $data['months'] = json_encode($months);
    $data['miningData'] = json_encode($miningData);
    $data['commissionData'] = json_encode($commissionData);

        //this is the referral code
    $data['referral_code'] = optional(auth()->user())->referral_code;

        //This is the check the agent status
    $data['agent_verify'] = optional(auth()->user())->agent_verify == 1 ? true : false;

        //check user wallet address 
    $wallet = \DB::table('user_address')->where('user_id', Auth::id())->first();
    if($wallet){
        $data['insert_wallet'] = true;
    }else{
        $data['insert_wallet'] = false;
    }

    $today = now();

    $getConfig = \DB::table('monthly_configs')
    ->whereDate('period_start', '<=', $today)
    ->get();

    $commissionSums = [
        'level1' => 0,
        'level2' => 0,
        'level3' => 0
    ];

    foreach ($getConfig as $config) {
        $referralReport = \Cache::get('referralReport_' . $config->id);
        
        if (!is_array($referralReport) || !isset($referralReport[Auth::id()])) {
            continue;
        }

        $referral = $referralReport[Auth::id()];

        foreach ($referral['level1'] as $level1) {
            $commissionSums['level1'] += $level1['commission'];

            foreach ($level1['level2'] as $level2) {
                $commissionSums['level2'] += $level2['commission'];

                foreach ($level2['level3'] as $level3) {
                    $commissionSums['level3'] += $level3['commission'];
                }
            }
        }
    }

// Check downlines
    $data['lvl1'] = 0;
    $data['lvl1_total'] = number_format($commissionSums['level1'],4);
    $data['lvl1percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 1)->first())->commission ?? 0);

    $level1Users = getDirectReferralUsers(Auth::id());
    $data['lvl1'] = $level1Users->count();

// lvl2
    $level2Users = collect();
    foreach ($level1Users as $level1User) {
        $level2Users = $level2Users->merge(getDirectReferralUsers($level1User->id));
    }
    $data['lvl2'] = $level2Users->count();
    $data['lvl2_total'] = number_format($commissionSums['level2'],4);
    $data['lvl2percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 2)->first())->commission ?? 0);

// lvl3
    $level3Users = collect();
    foreach ($level2Users as $level2User) {
        $level3Users = $level3Users->merge(getDirectReferralUsers($level2User->id));
    }
    $data['lvl3'] = $level3Users->count();
    $data['lvl3_total'] = number_format($commissionSums['level3'],4);
    $data['lvl3percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 3)->first())->commission ?? 0);


        //check the withdraw record and summary table 
    $getWithdrawHistory = \DB::table('withdraw_log')
    ->where('withdraw_log.user_id', Auth::id())
    ->join('summary', 'withdraw_log.parent_id', '=', 'summary.id')
    ->join('monthly_configs', 'summary.parent_id', '=', 'monthly_configs.id')
    ->select('withdraw_log.*','monthly_configs.period_start') 
    ->get();

    if ($getWithdrawHistory->count() > 0) {
        foreach ($getWithdrawHistory as $history) {
            $monthYear = date("M Y", strtotime($history->period_start)); 

            $data['transaction_allocation'][] = [
                'month_allocation' => "{$monthYear} Allocation", 
                'txid' => $history->tx_id,
                'amount' => $history->amount
            ];
        }
    } else {
        $data['transaction_allocation'] = [];
    }


    $data['recent_transaction'] = InvestHistory::with('plan')
    ->where('user_id', Auth::id())
    ->orderByDesc('created_at')
    ->limit(3)
    ->get();


    return view(template() . 'user.dashboard', $data);

}





public function profile()

{

    $data['languages'] = Language::all();

    $data['allKyc'] = Kyc::with('userKyc')->where('status', 1)->get();

    $data['user'] = Auth::user();

    return view(template() . 'user.profile.my_profile', $data);

}



public function profileUpdateImage(Request $request)

{

    try {

        $request->validate([

            'image' => 'required|image|mimes:png,jpg|max:3072',

        ]);

        $user = Auth::user();

        if ($request->hasFile('image')) {

            $image = $this->fileUpload($request->image, config('filelocation.userProfile.path'), null, null, 'png', 60, $user->image, $user->image_driver);

            if ($image) {

                $profileImage = $image['path'];

                $ImageDriver = $image['driver'];

            }

        }

        $user->image = $profileImage ?? $user->image;

        $user->image_driver = $ImageDriver ?? $user->image_driver;

        $user->save();

        return response()->json([
            'message' => 'Profile picture updated successfully.',
            'image_url' => getFile($user->image_driver, $user->image)
        ]);

    }catch (\Exception $exception){

        return response()->json(['err' => $exception->getMessage()],200);

    }

}



public function profileUpdate(Request $request)

{

    $languages = Language::all()->map(function ($item) {

        return $item->id;

    });



    $req = $request->except('_method', '_token');

    $user = Auth::user();

    $phoneCode = $request->phone_code;

    $rules = [

        'first_name' => 'required|string|min:1',

        'last_name' => 'required|string|min:1',

        'email' => 'email:rfc,dns|unique:users,email,' . $user->id,

        'phone' => ['required', 'string', new PhoneLength($phoneCode),Rule::unique('users', 'phone')->ignore($user->id)],

        'phone_code' => 'required | max:15',

        'country_code' => 'required | string | max:80',

        'country' => 'required | string | max:80',

        'username' => "sometimes|required|alpha_dash|min:5|unique:users,username," . $user->id,

        'address' => 'required',

        'language' => Rule::in($languages),

    ];

    $message = [

        'firstname.required' => 'First Name field is required',

        'lastname.required' => 'Last Name field is required',

    ];



    $validator = Validator::make($req, $rules, $message);

    if ($validator->fails()) {

        $validator->errors()->add('profile', '1');

        return back()->withErrors($validator)->withInput();

    }

    $user->language_id = $req['language'];

    $user->firstname = $req['first_name'];

    $user->lastname = $req['last_name'];

    $user->email = $req['email'];

    $user->username = $req['username'];

    $user->address_one = $req['address'];

    $user->phone = $req['phone'];

    $user->phone_code =  $req['phone_code'];

    $user->country_code = $req['country_code'];

    $user->country = $req['country'];

    $user->save();

    return back()->with('success', 'Updated Successfully.');

}





public function updatePassword(Request $request)

{

    $rules = [

        'current_password' => "required",

        'password' => "required|min:5|confirmed",

    ];



    $validator = Validator::make($request->all(), $rules);

    if ($validator->fails()) {

        return back()->withErrors($validator)->withInput();

    }

    $user = Auth::user();

    try {

        if (Hash::check($request->current_password, $user->password)) {

            $user->password = bcrypt($request->password);

            $user->save();

            return back()->with('success', 'Password Changes successfully.');

        } else {

            throw new \Exception('Current password did not match');

        }

    } catch (\Exception $e) {

        return back()->with('error', $e->getMessage());

    }

}





public function addFund()

{

    $data['basic'] = basicControl();

    $data['gateways'] = Gateway::where('status', 1)->orderBy('sort_by', 'ASC')->get();

    return view(template() . 'user.fund.add_fund', $data);

}



public function fund(Request $request)

{

    $trx = $request->trx_id;

    $filterDate = explode('to', $request->date_range);

    $startDate = $filterDate[0];

    $endDate = isset($filterDate[1]) ? trim($filterDate[1]) : null;

    $userId = Auth::id();

    $funds = Deposit::with(['depositable', 'gateway'])

    ->whereHas('gateway')

    ->where('depositable_type',Deposit::class)

    ->where('user_id', $userId)

    ->when(!empty($request->date_range) && $endDate == null, function ($query) use ($startDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $query->whereDate('created_at', $startDate);

    })

    ->when(!empty($request->date_range) && $endDate != null, function ($query) use ($startDate, $endDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $endDate = Carbon::parse(trim($endDate))->endOfDay();

        $query->whereBetween('created_at', [$startDate, $endDate]);

    })

    ->when(!empty($trx), function ($query) use ($trx) {



        return $query->where('trx_id', $trx);

    })

    ->orderBy('id', 'desc')

    ->latest()->paginate(15);

    return view($this->theme . 'user.fund.index', compact('funds'));

}





public function investPlan(Request $request)

{

        // validation rules

    $rules = [

        'balance_type' => 'required | in:checkout,balance,profit',

        'amount' => 'required|numeric',

        'plan_id' => 'required',

    ];



        // validate request

    $validator = Validator::make($request->all(), $rules);



        //if validation failed then return back with validation error message

    if ($validator->fails()) {

        return back()->with('error', $validator->errors()->first());

    }



    $balance_type = $request->balance_type;

    $user = Auth::guard('web')->user();



    try {



        $plan = InvestmentPlan::where(['status' => 1, 'id' => $request->plan_id])->firstOr(function () {

            throw new \Exception('Invalid plan request');

        });



        $amount = $request->amount;



            // validate invest amount , user balance & unit

        if ($plan->amount_has_fixed && $plan->plan_price > $amount){

            throw new \Exception("Please invest " . currencyPosition($plan->plan_price));

        }

        if (!$plan->amount_has_fixed && $plan->min_invest > $amount){

            throw new \Exception("Minimum Invest Limit " . currencyPosition($plan->min_invest));

        }

        if (!$plan->amount_has_fixed && $plan->max_invest < $amount){

            throw new \Exception("Maximum Invest Limit " . currencyPosition($plan->max_invest));

        }



            //if payment type or balance type is checkout then redirect to payment page

        if ($balance_type == 'checkout'){

            session()->put('amount', encrypt($amount));

            session()->put('plan_id', encrypt($plan->id));

            return  redirect()->route('user.payment');

        }



            // check balance type is profit balance or wallet balance

        if ($balance_type == 'profit'){



                //throw error if user profit balance is low

            if ($amount > $user->profit_balance) {

                throw  new  \Exception('Insufficient Balance');

            }



            $profit = $plan->Profit($amount);

                //make invest

            $invest =  BasicService::makeInvest($user,$plan,$profit,null,$amount);



            if ($invest){

                    //make transaction

                $transactional_type = 'App\Models\InvestmentPlan';

                $transaction = BasicService::makeTransaction($user,$amount,0,'-',$invest->trx,'Investment from profit balance',$transactional_type,'profit');

                $plan->transactional()->save($transaction);



                    //update user balance

                $user->profit_balance = getAmount($user->profit_balance - $amount);

                $user->total_invest += $amount;

                $user->save();



                    //distribute referral bonus for investment

                if (basicControl()->investment_commission && $user->referral_id){

                    DistributeBonus::dispatch($user, $amount, 'invest',$plan);

                }



                return redirect()->route('success')->with('success', 'Plan has been Purchased Successfully');

            }else{

                return  redirect()->route('failed')->with('error', 'Something Went Wrong');

            }

        }



            // if user balance type is wallet



            //throw error if user wallet balance is low

        if ($amount > $user->balance) {

            throw  new  \Exception('Insufficient Balance');

        }



        $profit = $plan->Profit($amount);



            // make invest

        $invest =  BasicService::makeInvest($user,$plan,$profit,null,$amount);



        if ($invest){



                //make transaction

            $transactional_type = 'App\Models\InvestmentPlan';

            $transaction = BasicService::makeTransaction($user,$amount,0,'-',$invest->trx,'Investment from wallet',$transactional_type,'wallet');

            $plan->transactional()->save($transaction);



                //update user balance

            $user->balance = getAmount($user->balance - $amount);

            $user->total_invest += $amount;

            $user->save();



                //distribute referral bonus for investment

            if (basicControl()->investment_commission && $user->referral_id){

                DistributeBonus::dispatch($user, $amount, 'invest',$plan);

            }

            return redirect()->route('success')->with('success', 'Plan has been Purchased Successfully');

        }else{

            return  redirect()->route('failed')->with('error', 'Something Went Wrong');

        }

    }catch (\Exception $exception) {

        return back()->with('error', $exception->getMessage());

    }

}



public function investment(Request $request)

{

    $name = $request->name;

    $filterDate = explode('to', $request->date_range);

    $startDate = $filterDate[0];

    $endDate = isset($filterDate[1]) ? trim($filterDate[1]) : null;



    $planInvestment = InvestHistory::with('plan')->where('user_id', Auth::id())

    ->when(!empty($request->date_range) && $endDate == null, function ($query) use ($startDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $query->whereDate('created_at', $startDate);

    })

    ->when(!empty($request->date_range) && $endDate != null, function ($query) use ($startDate, $endDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $endDate = Carbon::parse(trim($endDate))->endOfDay();

        $query->whereBetween('created_at', [$startDate, $endDate]);

    })

    ->when(!empty($name), function ($query) use ($name) {

        return $query->whereHas('plan',function ($query)use($name){

            return $query->where('plan_name','LIKE','%'.$name.'%');

        });

    })

    ->orderBy('created_at','DESC')->paginate(12);



    return view(template().'user.investment.plan_investment',compact('planInvestment'));

}


public function miningAllocation(Request $request)

{
    $user_id = Auth::id();
    $today = now();

    $transactions = InvestHistory::with('plan')
    ->where('user_id', $user_id)
    ->get();

    $getConfig = \DB::table('monthly_configs')->whereDate('period_start', '<=', $today)->get();

    $content = ContentSetting::where("type", "contract_and_agreement")->first();

    $miningRewards = collect($getConfig)
    ->flatMap(function ($config) use ($user_id) {
        $mining_report = \Cache::get('processedInvestments_' . $config->id);

        return collect($mining_report)
        ->where('user_id', $user_id)
        ->groupBy('trx')
        ->map(function ($items, $trx) {
            return [
                'trx' => $trx,
                'total_calculated_reward' => collect($items)->sum(fn($item) => (float) $item['calculated_reward']),
            ];
        })
        ->values();
    })
    ->groupBy('trx')
    ->map(function ($items, $trx) {
        return [
            'trx' => $trx,
            'total_calculated_reward' => $items->sum('total_calculated_reward'),
        ];
    });

    $transactions = $transactions->map(function ($transaction) use ($miningRewards) {
        $trx = $transaction->trx;

        $reward = $miningRewards->get($trx);
        $transaction->total_calculated_reward = $reward['total_calculated_reward'] ?? 0;

        return $transaction;
    });


    return view(template().'user.investment.mining-allocation',compact('transactions', 'content'));

}



public function orders()

{

    if (!basicControl()->ecommerce){

        abort(403);

    }

    $filterDate = explode('to', request()->date_range);

    $startDate = $filterDate[0];

    $endDate = isset($filterDate[1]) ? trim($filterDate[1]) : null;



    $orders = Order::query()

    ->orderBy('created_at','desc')

    ->where('user_id', Auth::id())

    ->when(request()->has('order_id') && request()->order_id, function ($query) {

        return $query->where('order_number',request()->order_id);

    })

    ->when(!empty(request()->date_range) && $endDate == null, function ($query) use ($startDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $query->whereDate('created_at', $startDate);

    })

    ->when(!empty(request()->date_range) && $endDate != null, function ($query) use ($startDate, $endDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $endDate = Carbon::parse(trim($endDate))->endOfDay();

        $query->whereBetween('created_at', [$startDate, $endDate]);

    })

    ->when(request()->has('status') && request()->status && request()->status !== 'all', function ($query) {

        if (request()->status == '4'){

            return $query->where('order_status', 0);

        }else{

            return $query->where('order_status', request()->status);

        }

    })

    ->paginate(15);



    return view(template().'user.order.index',compact('orders'));

}



public function orderItems($id)

{

    $orderItems = OrderItems::query()->with('product.details','order')->where('order_id',$id)->get();

    return view(template().'user.order.show',compact('orderItems'));

}





public function badges()

{

    $data['allBadges'] = Ranking::orderBy('sort_by', 'ASC')->get();

    return view(template() . 'user.badge.index', $data);

}



public function referralProgram()

{
        //to check the agent verified
    $userId = Auth::id();
    $checkVerify=User::where('id',$userId)->pluck('agent_verify');
    if($checkVerify[0]==1){
        $data['verify'] = True;
    }else{
        $data['verify'] = False;
    }

    $data['title'] = "My Referrals";
        //user referral code
    $data['referral_code'] = optional(auth()->user())->referral_code;

    $commissionSums = [
        'level1' => 0,
        'level2' => 0,
        'level3' => 0
    ];
    $data['referral_structure'] = [];
    $today = now();

    $getConfig = \DB::table('monthly_configs')
    ->whereDate('period_start', '<=', $today)
    ->get();
    foreach ($getConfig as $config) {
        $referralReport = \Cache::get('referralReport_' . $config->id);

        if (!is_array($referralReport) || !isset($referralReport[$userId])) {
            continue;
        }

        $referral = $referralReport[$userId];

        foreach ($referral['level1'] as $level1) {
            $email = $level1['user_email'] ?? '';
            $key = $level1['user_id']; 

            if (!isset($data['referral_structure'][$key])) {
                $data['referral_structure'][$key] = [
                    'user_id' => $key, 
                    'username' => $level1['user_name'] ?? '',
                    'email' => $email,
                    'commission' => $level1['commission'] ?? 0,
                    'date' => $level1['start_date'] ?? '',
                    'level2' => []
                ];
            } else {
                $data['referral_structure'][$key]['commission'] += $level1['commission'] ?? 0;
                if (empty($data['referral_structure'][$key]['date'])) {
                    $data['referral_structure'][$key]['date'] = $level1['start_date'] ?? '';
                }
            }


        // Process level2
            foreach ($level1['level2'] ?? [] as $level2) {
                $level2Email = $level2['user_email'] ?? '';
                $level2Key = $level2['user_id'];

            // Find or create this level2 under current level1
                $existingLevel2Index = collect($data['referral_structure'][$key]['level2'])->search(function ($l2) use ($level2Key) {
                    return $l2['user_id'] === $level2Key;
                });

                if ($existingLevel2Index === false) {
                    $level2User = [
                        'user_id' => $level2Key, 
                        'username' => $level2['user_name'] ?? '',
                        'email' => $level2Email,
                        'commission' => $level2['commission'] ?? 0,
                        'date' => $level2['start_date'] ?? '',
                        'level3' => []
                    ];

                    $data['referral_structure'][$key]['level2'][] = $level2User;
                    $existingLevel2Index = array_key_last($data['referral_structure'][$key]['level2']);
                } else {
                    $data['referral_structure'][$key]['level2'][$existingLevel2Index]['commission'] += $level2['commission'] ?? 0;
                    if (empty($data['referral_structure'][$key]['level2'][$existingLevel2Index]['date'])) {
                        $data['referral_structure'][$key]['level2'][$existingLevel2Index]['date'] = $level2['start_date'] ?? '';
                    }
                }


            // Process level3
                foreach ($level2['level3'] ?? [] as $level3) {
                    $level3Email = $level3['user_email'] ?? '';
                    $level3Key = $level3['user_id'];
                    $existingLevel3Index = collect($data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'])->search(function ($l3) use ($level3Key) {
                        return $l3['user_id'] === $level3Key;
                    });


                    if ($existingLevel3Index === false) {
                        $data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'][] = [
                            'user_id' => $level3Key,
                            'username' => $level3['user_name'] ?? '',
                            'email' => $level3Email,
                            'commission' => $level3['commission'] ?? 0,
                            'date' => $level3['start_date'] ?? '',
                        ];
                    } else {
                        $data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'][$existingLevel3Index]['commission'] += $level3['commission'] ?? 0;
                        if (empty($data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'][$existingLevel3Index]['date'])) {
                            $data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'][$existingLevel3Index]['date'] = $level3['start_date'] ?? '';
                        }
                    }

                }
            }
        }
    }
    foreach ($getConfig as $config) {
        $referralReport = \Cache::get('referralReport_' . $config->id);

        if (!is_array($referralReport) || !isset($referralReport[Auth::id()])) {
            continue;
        }

        $referral = $referralReport[Auth::id()];

        foreach ($referral['level1'] as $level1) {
            $commissionSums['level1'] += $level1['commission'];

            foreach ($level1['level2'] as $level2) {
                $commissionSums['level2'] += $level2['commission'];

                foreach ($level2['level3'] as $level3) {
                    $commissionSums['level3'] += $level3['commission'];
                }
            }
        }
    }

        // Check downlines
    $data['lvl1'] = 0;
    $data['lvl1_total'] = number_format($commissionSums['level1'],4);
    $data['lvl1percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 1)->first())->commission ?? 0);

    $level1Users = getDirectReferralUsers(Auth::id());
    $data['lvl1'] = $level1Users->count();

        // lvl2
    $level2Users = collect();
    foreach ($level1Users as $level1User) {
        $level2Users = $level2Users->merge(getDirectReferralUsers($level1User->id));
    }
    $data['lvl2'] = $level2Users->count();
    $data['lvl2_total'] = number_format($commissionSums['level2'],4);
    $data['lvl2percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 2)->first())->commission ?? 0);

        // lvl3
    $level3Users = collect();
    foreach ($level2Users as $level2User) {
        $level3Users = $level3Users->merge(getDirectReferralUsers($level2User->id));
    }
    $data['lvl3'] = $level3Users->count();
    $data['lvl3_total'] = number_format($commissionSums['level3'],4);
    $data['lvl3percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 3)->first())->commission ?? 0);


    return view(template().'user.referral.referral-program',$data);

}



public function affiliateProgram()

{
        //to check the agent verified
    $userId = Auth::id();
    $checkVerify=User::where('id',$userId)->pluck('agent_verify');
    if($checkVerify[0]==1){
        $data['verify'] = True;
    }else{
        $data['verify'] = False;
    }

    $data['title'] = "My Referrals";
        //user referral code
    $data['referral_code'] = optional(auth()->user())->referral_code;

    $commissionSums = [
        'level1' => 0,
        'level2' => 0,
        'level3' => 0
    ];
    $data['referral_structure'] = [];
    $today = now();

    $getConfig = \DB::table('monthly_configs')
    ->whereDate('period_start', '<=', $today)
    ->get();
    foreach ($getConfig as $config) {
        $referralReport = \Cache::get('referralReport_' . $config->id);

        if (!is_array($referralReport) || !isset($referralReport[$userId])) {
            continue;
        }

        $referral = $referralReport[$userId];

        foreach ($referral['level1'] as $level1) {
            $email = $level1['user_email'] ?? '';
        $key = $level1['user_id']; // Use email as a unique key; can use user ID if available

        if (!isset($data['referral_structure'][$key])) {
            $data['referral_structure'][$key] = [
                'username' => $level1['user_name'] ?? '',
                'email' => $email,
                'commission' => $level1['commission'] ?? 0,
                'date' => $level1['start_date'] ?? '',
                'level2' => []
            ];
        } else {
            $data['referral_structure'][$key]['commission'] += $level1['commission'] ?? 0;
        }

        // Process level2
        foreach ($level1['level2'] ?? [] as $level2) {
            $level2Email = $level2['user_email'] ?? '';
            $level2Key = $level2['user_id'];

            // Find or create this level2 under current level1
            $existingLevel2Index = collect($data['referral_structure'][$key]['level2'])->search(function ($l2) use ($level2Key) {
                return $l2['email'] === $level2Key;
            });

            if ($existingLevel2Index === false) {
                $level2User = [
                    'username' => $level2['user_name'] ?? '',
                    'email' => $level2Email,
                    'commission' => $level2['commission'] ?? 0,
                    'date' => $level2['start_date'] ?? '',
                    'level3' => []
                ];

                $data['referral_structure'][$key]['level2'][] = $level2User;
                $existingLevel2Index = array_key_last($data['referral_structure'][$key]['level2']);
            } else {
                $data['referral_structure'][$key]['level2'][$existingLevel2Index]['commission'] += $level2['commission'] ?? 0;
            }

            // Process level3
            foreach ($level2['level3'] ?? [] as $level3) {
                $level3Email = $level3['user_email'] ?? '';
                $existingLevel3Index = collect($data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'])->search(function ($l3) use ($level3Email) {
                    return $l3['email'] === $level3Email;
                });

                if ($existingLevel3Index === false) {
                    $data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'][] = [
                        'username' => $level3['user_name'] ?? '',
                        'email' => $level3Email,
                        'commission' => $level3['commission'] ?? 0,
                        'date' => $level3['start_date'] ?? '',
                    ];
                } else {
                    $data['referral_structure'][$key]['level2'][$existingLevel2Index]['level3'][$existingLevel3Index]['commission'] += $level3['commission'] ?? 0;
                }
            }
        }
    }
}

foreach ($getConfig as $config) {
    $referralReport = \Cache::get('referralReport_' . $config->id);

    if (!is_array($referralReport) || !isset($referralReport[Auth::id()])) {
        continue;
    }

    $referral = $referralReport[Auth::id()];

    foreach ($referral['level1'] as $level1) {
        $commissionSums['level1'] += $level1['commission'];

        foreach ($level1['level2'] as $level2) {
            $commissionSums['level2'] += $level2['commission'];

            foreach ($level2['level3'] as $level3) {
                $commissionSums['level3'] += $level3['commission'];
            }
        }
    }
}

        // Check downlines
$data['lvl1'] = 0;
$data['lvl1_total'] = number_format($commissionSums['level1'],4);
$data['lvl1percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 1)->first())->commission ?? 0);

$level1Users = getDirectReferralUsers(Auth::id());
$data['lvl1'] = $level1Users->count();

        // lvl2
$level2Users = collect();
foreach ($level1Users as $level1User) {
    $level2Users = $level2Users->merge(getDirectReferralUsers($level1User->id));
}
$data['lvl2'] = $level2Users->count();
$data['lvl2_total'] = number_format($commissionSums['level2'],4);
$data['lvl2percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 2)->first())->commission ?? 0);

        // lvl3
$level3Users = collect();
foreach ($level2Users as $level2User) {
    $level3Users = $level3Users->merge(getDirectReferralUsers($level2User->id));
}
$data['lvl3'] = $level3Users->count();
$data['lvl3_total'] = number_format($commissionSums['level3'],4);
$data['lvl3percentage'] = intval(optional(Referral::where('commission_type', 'profit_commission')->where('level', 3)->first())->commission ?? 0);


return view(template().'user.referral.referral-program',$data);

}



public function referral()

{

    $userId = Auth::id();

    $data['title'] = "My Referrals";
    $data['referral_code'] = optional(auth()->user())->referral_code;

    $data['directReferralUsers'] = getDirectReferralUsers($userId);

    return view(template().'user.referral.referral',$data);

}

public function referralBonus(Request $request)

{



    $remark = $request->remark;

    $filterDate = explode('to', $request->date_range);

    $startDate = $filterDate[0];

    $endDate = isset($filterDate[1]) ? trim($filterDate[1]) : null;

    $commission_type = $request->type;





    $referrals = ReferralBonus::query()->with(['user:id,username,firstname,lastname,image,image_driver'])

    ->where('from_user_id', Auth::id())

    ->orderBy('created_at','desc')

    ->when(!empty($request->date_range) && $endDate == null, function ($query) use ($startDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $query->whereDate('created_at', $startDate);

    })

    ->when(!empty($request->date_range) && $endDate != null, function ($query) use ($startDate, $endDate) {

        $startDate = Carbon::parse(trim($startDate))->startOfDay();

        $endDate = Carbon::parse(trim($endDate))->endOfDay();

        $query->whereBetween('created_at', [$startDate, $endDate]);

    })

    ->when(!empty($remark), function ($query) use ($remark) {

        return $query->where('remarks', $remark);

    })

    ->when(!empty($commission_type),function ($query) use ($commission_type){

        return $query->where('commission_type', $commission_type);

    })

    ->paginate(15);



    return view(template().'user.referral.referral_bonus',compact('referrals'));

}



public function getReferralsBonus()

{

    $referrals = ReferralBonus::where('from_user_id', Auth::id())

    ->selectRaw('MONTH(created_at) as month, YEAR(created_at) as year, SUM(amount) as total')

    ->groupBy('month', 'year')

    ->get();

    return response()->json([

        'referrals' => $this->formatChartData($referrals),

    ]);

}



public function getReferralUser(Request $request)

{

    $data = getDirectReferralUsers($request->userId);

    $directReferralUsers = $data->map(function ($user) {

        return [

            'id' => $user->id,

            'username' => $user->username,

            'email' => $user->email,

            'phone' => $user->phone,

            'count_direct_referral' => count(getDirectReferralUsers($user->id)),

            'joined_at' => dateTime($user->created_at),

        ];

    });



    return response()->json(['data' => $directReferralUsers]);

}



public function transactions(Request $request)

{

    $dateRange = str_replace('to', '', $request->date_range);

    $dateRange = preg_replace('/\s+/', ' ', $dateRange);

    $dateArray = array_map('trim', explode(' ', $dateRange));

    $fromDate = false;

    $toDate = false;

    if ($request->date_range){

        $fromDate = $dateArray[0];

        $toDate = $dateArray[1];

    }



    $transactions = Transaction::where('user_id', Auth::id())

    ->when($request->trx_id , function ($query) use ($request){

        $query->where('trx_id',$request->trx_id);

    })

    ->when($request->remark , function ($query) use ($request){

        $query->where('remarks','LIKE','%'.$request->remark.'%');

    })

    ->when($fromDate && $toDate , function ($query) use ($fromDate ,$toDate){

        $query->whereBetween('created_at', [$fromDate, $toDate]);

    })

    ->orderBy('created_at', 'desc')

    ->paginate(15);



    return view(template().'user.transaction.index',compact('transactions'));

}



public function transactionsHistory(Request $request)
{
    $fromDate = null;
    $toDate = null;

    if ($request->filled('date_range')) {
        $dateRange = preg_replace('/\s+to\s+/', ',', $request->date_range);
        $dateArray = explode(',', $dateRange);
        $fromDate = trim($dateArray[0] ?? '');
        $toDate = trim($dateArray[1] ?? '');
    }

    // Correct transaction
    $transactions = InvestHistory::with('plan')
    ->where('user_id', Auth::id())
    ->when($fromDate && $toDate, function ($query) use ($fromDate, $toDate) {
        $query->whereBetween('created_at', [$fromDate, $toDate]);
    })
    ->orderBy('created_at', 'desc')
    ->paginate(15)
    ->appends($request->only('date_range'));

    // Second transaction with filter applied
    $getWithdrawHistory = \DB::table('withdraw_log')
    ->where('withdraw_log.user_id', Auth::id())
    ->when($fromDate && $toDate, function ($query) use ($fromDate, $toDate) {
        $query->whereBetween('withdraw_log.created_at', [$fromDate, $toDate]);
    })
    ->join('summary', 'withdraw_log.parent_id', '=', 'summary.id')
    ->join('monthly_configs', 'summary.parent_id', '=', 'monthly_configs.id')
    ->select('withdraw_log.*','monthly_configs.period_start') 
    ->get();

    if ($getWithdrawHistory->count() > 0) {
        foreach ($getWithdrawHistory as $history) {

            $data['transaction_allocation'][] = [
                'month_allocation' => $history->period_start, 
                'txid' => $history->tx_id,
                'amount' => $history->amount
            ];
        }
    } else {
        $data['transaction_allocation'] = [];
    }

    return view(template().'user.transaction.history', compact('transactions', 'request', 'data'));
}





public function investHistory(Request $request)

{



    $startDate = Carbon::parse($request->start_date);

    $endDate = Carbon::parse($request->end_date);



    $diffInDays = $startDate->diffInDays($endDate);

    $groupBy = $diffInDays <= 1 ? 'HOUR' : 'DATE';

    $dateFormat = $diffInDays <= 1 ? 'ga' : 'd-M';



    $planInvest = InvestHistory::where('user_id', Auth::id())

    ->whereBetween('created_at', [$startDate, $endDate])

    ->selectRaw($groupBy . '(created_at) as period, SUM(invest_amount) as total')

    ->groupBy('period')

    ->get();



    $referrals = ReferralBonus::where('from_user_id', Auth::id())

    ->whereBetween('created_at', [$startDate, $endDate])

    ->selectRaw($groupBy . '(created_at) as period, SUM(amount) as total')

    ->groupBy('period')

    ->get();



    $labels = [];

    $investData = [];

    $revenueData = [];



    foreach ($planInvest as $data) {

        $period = $data->period;

        $formattedPeriod = $diffInDays <= 1 ? date($dateFormat, strtotime($period . ':00')) : date($dateFormat, strtotime($period));

        $labels[] = $formattedPeriod;

        $investData[] = $data->total;

    }



    foreach ($referrals as $data) {

        $period = $data->period;

        $formattedPeriod = $diffInDays <= 1 ? date($dateFormat, strtotime($period . ':00')) : date($dateFormat, strtotime($period));

        $labels[] = $formattedPeriod;

        $revenueData[] = $data->total;

    }





    $response = [

        'labels' => $labels,

        'datasets' => [

            [

                'name' => 'Investment',

                'data' => $investData,

            ],

            [

                'name' => 'Referral Bonus',

                'data' => $revenueData,

            ],

        ]

    ];



    return response()->json($response);



}



public function depositPayout(Request $request)

{

    $startDate = Carbon::parse($request->start_date);

    $endDate = Carbon::parse($request->end_date)->endOfDay();



    $diffInDays = $startDate->diffInDays($endDate);

    $groupBy = $diffInDays <= 1 ? 'HOUR' : 'DATE';

    $dateFormat = $diffInDays <= 1 ? 'ga' : 'd-M';



    $deposits = Deposit::where('user_id', Auth::id())

    ->where('status', 1)

    ->where('depositable_type', Deposit::class)

    ->whereBetween('created_at', [$startDate, $endDate])

    ->selectRaw($groupBy . '(created_at) as period, SUM(payable_amount_in_base_currency) as total')

    ->groupBy('period')

    ->get();





    $payouts = Payout::where('user_id', Auth::id())

    ->where('status', 2)

    ->whereBetween('created_at', [$startDate, $endDate])

    ->selectRaw($groupBy . '(created_at) as period, SUM(amount_in_base_currency) as total')

    ->groupBy('period')

    ->get();



    $labels = [];

    $depositData = [];

    $payoutData = [];



    foreach ($deposits as $data) {

        $period = $data->period;

        $formattedPeriod = $diffInDays <= 1 ? date($dateFormat, strtotime($period . ':00')) : date($dateFormat, strtotime($period));

        $labels[] = $formattedPeriod;

        $depositData[] = $data->total;

    }



    foreach ($payouts as $data) {

        $period = $data->period;

        $formattedPeriod = $diffInDays <= 1 ? date($dateFormat, strtotime($period . ':00')) : date($dateFormat, strtotime($period));

        $labels[] = $formattedPeriod;

        $payoutData[] = $data->total;

    }



    return response()->json([

        'deposits' => $depositData,

        'payouts' => $payoutData,

        'labels' => $labels,

    ]);



}



public function transactionHistory(Request $request)

{

    $startDate = Carbon::parse($request->start_date);

    $endDate = Carbon::parse($request->end_date)->endOfDay();



    $diffInDays = $startDate->diffInDays($endDate);

    $groupBy = $diffInDays <= 1 ? 'HOUR' : 'DATE';

    $dateFormat = $diffInDays <= 1 ? 'ga' : 'd-M';



    $transactions = Transaction::where('user_id', Auth::id())

    ->whereBetween('created_at', [$startDate, $endDate])

    ->selectRaw($groupBy . '(created_at) as period, SUM(amount) as total')

    ->groupBy('period')

    ->get();



    $labels = [];

    $transactionData = [];



    foreach ($transactions as $data) {

        $period = $data->period;

        $formattedPeriod = $diffInDays <= 1 ? date($dateFormat, strtotime($period . ':00')) : date($dateFormat, strtotime($period));

        $labels[] = $formattedPeriod;

        $transactionData[] = $data->total;

    }

    return response()->json([

        'transactions' => $transactionData,

        'labels' => $labels,

    ]);

}



public function addSubscription()

{
    $content = ContentSetting::where("type", "contract_and_agreement")->first();

    $plans = InvestmentPlan::where(['status' => 1, 'soft_delete' => 0])

    ->orderBy('created_at', 'desc')

    ->paginate(15);

    $recent_transaction = InvestHistory::with('plan')
    ->where('user_id', Auth::id())
    ->orderByDesc('created_at')
    ->get();
    $inventory = (int) \DB::table('dbc_plan_inventory')->first()->quantity;

    $planPurchased = (int) \DB::table('invest_histories')
    ->whereDate('plan_expiry_date', '>=', Carbon::today()) 
    ->sum('quantity');

    $available = max(0, $inventory - $planPurchased); 

    $soldOut = $available <= 0;
    return view(template().'user.hashpower.index', compact('plans','content','recent_transaction','available','soldOut'));

}



private function getFormattedDates()

{

    $formattedDates = [];

    for ($month = 1; $month <= 12; $month++) {

        $date = Carbon::create(now()->year, $month, 1);

            $formattedDates[] = $date->format('M');  // Short month name

        }



        return $formattedDates;

    }



    private function formatChartData($data)

    {

        $formattedData = array_fill(0, 12, 0);

        foreach ($data as $item) {

            $formattedData[$item->month - 1] = getAmount($item->total);

        }

        return $formattedData;

    }



}

