<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContentSetting;
use Illuminate\Http\Request;

class ContentSettingController extends Controller
{
    // View Listing
    public function index()
    {
        $contentSettings = ContentSetting::all();
        return view('admin.content_setting.index', compact('contentSettings'));
    }

    // Show create form
    public function create()
    {
        return view('admin.content_setting.create');
    }

    // Store new content setting
    public function store(Request $request)
    {
        $request->validate([
            'content' => 'required',
            'subject' => 'required',
            'type' => 'required',
        ]);

        ContentSetting::create([
            'content' => $request->content,
            'subject' => $request->subject,
            'type' => $request->type,
        ]);

        return redirect()
            ->route('admin.contentsetting.index')
            ->with('success', 'Content created successfully!');
    }

    // Show edit form
    public function edit($id)
    {
        $contentSetting = ContentSetting::findOrFail($id);
        return view('admin.content_setting.edit', compact('contentSetting'));
    }

    // Update existing content setting
    public function update(Request $request, $id)
    {
        $request->validate([
            'content' => 'required',
            'subject' => 'required',
            'type' => 'required',
        ]);

        $contentSetting = ContentSetting::findOrFail($id);
        $contentSetting->update([
            'content' => $request->content,
            'subject' => $request->subject,
            'type' => $request->type,
        ]);

        return redirect()
            ->route('admin.contentsetting.index')
            ->with('success', 'Content updated successfully!');
    }
}
