
<?php $__env->startSection('page_title', __('Overview')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title"><?php echo app('translator')->get('Overview'); ?></h1>
            </div>
            <div class="col-sm-auto">
                <a href="<?php echo e(route('admin.monthly.plan.index')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Back to List'); ?></a>
                <?php if($status != 1): ?>
                <form method="POST" action="<?php echo e(route('admin.monthly.plan.approve', $configId)); ?>" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to approve this configuration?')">
                        <?php echo app('translator')->get('Approve Configuration'); ?>
                    </button>
                </form>
                <?php endif; ?>

            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <div class="row">
        <div class="col-lg-8">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title"><?php echo app('translator')->get('Mining Report'); ?></h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Customer ID'); ?></th>
                                    <th><?php echo app('translator')->get('Customer Name'); ?></th>
                                    <th><?php echo app('translator')->get('Plan'); ?></th>
                                    <th><?php echo app('translator')->get('Quantity'); ?></th>
                                    <th><?php echo app('translator')->get('Purchased At'); ?></th>
                                    <th><?php echo app('translator')->get('Start Date'); ?></th>
                                    <th><?php echo app('translator')->get('End Date'); ?></th>
                                    <th><?php echo app('translator')->get('Days Vested'); ?></th>
                                    <th><?php echo app('translator')->get('Hash Rate'); ?></th>
                                    <th><?php echo app('translator')->get('Mining Reward'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $processedInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($investment['user_id']); ?></td>
                                    <td><?php echo e($investment['user_name']); ?></td>
                                    <td>
                                        <?php
                                        $plan = \App\Models\InvestmentPlan::find($investment['planId']);
                                        ?>
                                        <?php echo e($plan->plan_name ?? 'N/A'); ?>

                                    </td>                                  
                                    <td><?php echo e($investment['quantity']); ?></td>
                                    <td><?php echo e($investment['purchased_date']); ?></td>
                                    <td><?php echo e($investment['effective_start_date']); ?></td>
                                    <td><?php echo e($investment['effective_end_date']); ?></td>
                                    <td><?php echo e($investment['days_invested']); ?></td>
                                    <td><?php echo e($investment['hashrate']); ?></td>
                                    <td><?php echo e(number_format($investment['calculated_reward'], 4, '.', ',')); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title"><?php echo app('translator')->get('Summary'); ?></h4>
                </div>
<div class="card-body">
    <div class="mb-3">
        <h6><?php echo app('translator')->get('Period'); ?></h6>
        <p><?php echo e($summary['start_date']); ?> to <?php echo e($summary['end_date']); ?></p>
    </div>      
    <div class="mb-3">
        <h6><?php echo app('translator')->get('Total Date Period'); ?></h6>
        <p><?php echo e($summary['total_date_period']); ?></p>
    </div>
    <div class="mb-3">
        <h6><?php echo app('translator')->get('Total Reward'); ?></h6>
        <p><?php echo e(number_format($summary['total_reward_setting'], 4, '.', ',')); ?></p>
    </div>
    <div class="mb-3">
        <h6><?php echo app('translator')->get('Total Operation Cost'); ?></h6>
        <p><?php echo e(number_format($summary['total_operation_cost'], 4, '.', ',')); ?></p>
    </div>
    <hr>
    <div class="mb-3">
        <h6><?php echo app('translator')->get('Reward Per Day'); ?></h6>
        <p><?php echo e(number_format($summary['reward_per_day'], 4, '.', ',')); ?></p>
    </div>
    <hr>
    <div class="mb-3">
        <h6><?php echo app('translator')->get('Total Investments'); ?></h6>
        <p><?php echo e($summary['total_investments']); ?></p>
    </div>
    <div class="mb-3">
        <h6><?php echo app('translator')->get('Total Investments Machines'); ?></h6>
        <p><?php echo e($summary['total_quantity']); ?></p>
    </div>
    <hr>
    <div class="mb-3">
        <h5><?php echo app('translator')->get('Total Projected Rewards'); ?></h5>
        <h4><?php echo e(number_format($summary['total_reward'], 4, '.', ',')); ?></h4>
    </div>
</div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_config/calculator.blade.php ENDPATH**/ ?>