
<?php $__env->startSection('page_title', __('Basic Control')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item">
                            <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Settings'); ?></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Basic Control'); ?></li>
                    </ol>
                </nav>
                <h1 class="page-header-title"><?php echo app('translator')->get('Basic Control'); ?></h1>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="alert alert-soft-dark " role="alert">
                <div class="alert-box d-flex flex-wrap align-items-center">
                    <div class="flex-shrink-0">
                        <img class="avatar avatar-xl"
                        src="<?php echo e(asset('assets/admin/img/oc-megaphone.svg')); ?>"
                        alt="Image Description" data-hs-theme-appearance="default">
                        <img class="avatar avatar-xl"
                        src="<?php echo e(asset('assets/admin/img/oc-megaphone-light.svg')); ?>"
                        alt="Image Description" data-hs-theme-appearance="dark">
                    </div>

                    <div class="flex-grow-1 ms-3">
                        <h3 class=" mb-1"><?php echo app('translator')->get("Attention!"); ?></h3>
                        <div class="d-flex align-items-center">
                            <p class="mb-0 text-body"> <?php echo app('translator')->get(" If you get 500(server error) for some reason, please turn on `Debug Log` and try again. Then you can see what was missing in your system. "); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3">
            <?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="col-lg-5" id="basic_control">
            <div class="d-grid gap-3 gap-lg-5">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title h4"><?php echo app('translator')->get('Basic Controls'); ?></h2>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.basic.control.update')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row mb-3">
                                <div class="col-sm-6">
                                    <label for="siteTitleLabel" class="form-label"><?php echo app('translator')->get('Site Title'); ?></label>
                                    <input type="text"
                                    class="form-control  <?php $__errorArgs = ['site_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="site_title" id="siteTitleLabel"
                                    placeholder="<?php echo app('translator')->get("Site Title"); ?>" aria-label="<?php echo app('translator')->get("Site Title"); ?>"
                                    autocomplete="off"
                                    value="<?php echo e(old('site_title', $basicControl->site_title)); ?>">
                                    <?php $__errorArgs = ['site_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-sm-6">
                                    <label for="timeZoneLabel" class="form-label"><?php echo app('translator')->get('Time Zone'); ?></label>
                                    <div class="tom-select-custom">
                                        <select
                                        class="js-select form-select <?php $__errorArgs = ['time_zone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="timeZoneLabel" name="time_zone">
                                        <?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                        value="<?php echo e($value); ?>" <?php echo e((old('time_zone',$basicControl->time_zone) == $value ? ' selected' : '')); ?>><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <?php $__errorArgs = ['time_zone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-sm-6">
                                <label for="baseCurrencyLabel" class="form-label"><?php echo app('translator')->get('Base Currency'); ?></label>
                                <input type="text"
                                class="form-control  <?php $__errorArgs = ['base_currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="base_currency"
                                id="baseCurrencyLabel" autocomplete="off"
                                placeholder="<?php echo app('translator')->get("Base Currency"); ?>" aria-label="<?php echo app('translator')->get("Base Currency"); ?>"
                                value="<?php echo e(old('base_currency',$basicControl->base_currency)); ?>">
                                <?php $__errorArgs = ['base_currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-sm-6">
                                <label for="CurrencySymbolLabel"
                                class="form-label"><?php echo app('translator')->get('Currency Symbol'); ?></label>
                                <input type="text"
                                class="form-control <?php $__errorArgs = ['currency_symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="currency_symbol"
                                id="CurrencySymbolLabel" autocomplete="off"
                                placeholder="<?php echo app('translator')->get("Currency Symbol"); ?>"
                                aria-label="<?php echo app('translator')->get("Currency Symbol"); ?>"
                                value="<?php echo e(old('currency_symbol',$basicControl->currency_symbol)); ?>">
                                <?php $__errorArgs = ['currency_symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-sm-6">
                                <label for="fractionNumberLabel"
                                class="form-label"><?php echo app('translator')->get('Fraction Number'); ?></label>
                                <input type="text"
                                class="form-control <?php $__errorArgs = ['fraction_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="fraction_number"
                                id="fractionNumberLabel"
                                placeholder="<?php echo app('translator')->get("Fraction Number"); ?>"
                                aria-label="<?php echo app('translator')->get("Fraction Number"); ?>"
                                autocomplete="off"
                                value="<?php echo e(old('fraction_number',$basicControl->fraction_number)); ?>">
                                <?php $__errorArgs = ['fraction_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-sm-6">
                                <label for="paginateLabel" class="form-label"><?php echo app('translator')->get('Paginate'); ?></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['paginate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="paginate" id="paginateLabel"
                                placeholder="Paginate" aria-label="Paginate" autocomplete="off"
                                value="<?php echo e(old('paginate',$basicControl->paginate)); ?>">
                                <?php $__errorArgs = ['paginate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <?php if($basicControl->ecommerce): ?>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="vatLabel" class="form-label"><?php echo app('translator')->get('Vat'); ?></label>

                                <div class="input-group mb-3">
                                    <input type="number"  name="vat" id="vatLabel"  value="<?php echo e(old('vat',$basicControl->vat+0)); ?>" class="form-control  <?php $__errorArgs = ['vat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Vat" aria-label="Vat" step="0.01" >
                                    <span class="input-group-text" id="basic-addon2">%</span>
                                </div>
                                <?php $__errorArgs = ['vat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="working_costLabel" class="form-label"><?php echo app('translator')->get('Working Cost'); ?></label>

                                <div class="input-group mb-3">
                                    <input type="number"  name="working_cost" id="working_costLabel"  value="<?php echo e(old('working_cost',$basicControl->working_cost+0)); ?>" class="form-control  <?php $__errorArgs = ['working_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Working Cost" aria-label="Working Cost" step="0.01" >
                                    <span class="input-group-text" id="basic-addon2">%</span>
                                </div>
                                <?php $__errorArgs = ['working_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-sm-12">
                                <label for="instructionsLabel" class="form-label"><?php echo app('translator')->get('Order invoice instruction'); ?></label>

                                <div class="input-group mb-3">
                                    <input type="text"  name="instructions" id="vatLabel"  value="<?php echo e(old('instructions',$basicControl->instructions)); ?>" class="form-control  <?php $__errorArgs = ['instructions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Instructions" aria-label="Instructions"  >
                                </div>
                                <?php $__errorArgs = ['instructions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="row mb-3">
                            <div class="col-sm-12">
                                <label for="instructionsLabel" class="form-label"><?php echo app('translator')->get('Investment Terminate Charge'); ?></label>

                                <div class="input-group mb-3">
                                    <input type="number"  name="terminate_charge" id="vatLabel"  value="<?php echo e(old('terminate_charge',$basicControl->terminate_charge)); ?>" class="form-control  <?php $__errorArgs = ['terminate_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Termination Charge" aria-label="Termination Charge"  step="0.01">
                                    <span class="input-group-text">%</span>
                                </div>

                                <?php $__errorArgs = ['terminate_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-sm-12">
                                <label for="dateFormatLabel" class="form-label"><?php echo app('translator')->get('Date Format'); ?></label>
                                <div class="tom-select-custom">
                                    <select
                                    class="js-select form-select <?php $__errorArgs = ['date_format'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="dateFormatLabel" name="date_format">
                                    <?php $__currentLoopData = $dateFormat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                    value="<?php echo e(__($value)); ?>" <?php echo e((old('time_zone',$basicControl->date_time_format) == $value ? ' selected' : '')); ?>><?php echo e(date($value,time())); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php $__errorArgs = ['date_format'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-sm-12">
                            <label for="adminPrefixLabel"
                            class="form-label"><?php echo app('translator')->get("Admin URL Prefix"); ?></label>
                            <input type="text"
                            class="form-control <?php $__errorArgs = ['admin_prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            name="admin_prefix" id="adminPrefixLabel"
                            placeholder="<?php echo app('translator')->get("Admin Prefix"); ?>"
                            aria-label="<?php echo app('translator')->get("Admin URL Prefix"); ?>"
                            autocomplete="off"
                            value="<?php echo e(old('admin_prefix', $basicControl->admin_prefix)); ?>">
                            <?php $__errorArgs = ['admin_prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="row mb-3">
                            <div class="col-sm-12">
                                <label for="tutorialLabel" class="form-label"><?php echo app('translator')->get('Youtube Tutorial Link'); ?></label>

                                <div class="input-group mb-3">
                                    <input type="text"  name="tutorial" id="vatLabel"  value="<?php echo e(old('tutorial',$basicControl->tutorial)); ?>" class="form-control  <?php $__errorArgs = ['tutorial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="tutorial" aria-label="tutorial"  >
                                </div>
                                <?php $__errorArgs = ['tutorial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>a
                    </div>

                    <div class="row mb-3">
                        <div class="col-sm-12">
                            <div class="color_setting">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="primaryColorLabel"
                                        class="form-label"><?php echo app('translator')->get('Primary Color'); ?></label>
                                        <input type="color"
                                        class="form-control color-form-input <?php $__errorArgs = ['primary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="primary_color"
                                        id="primaryColorLabel"
                                        placeholder="Primary Color" aria-label="Primary Color"
                                        value="<?php echo e(old('primary_color',$basicControl->primary_color)); ?>">
                                        <?php $__errorArgs = ['primary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="secondaryColorLabel"
                                        class="form-label"><?php echo app('translator')->get('Secondary Color'); ?></label>
                                        <input type="color"
                                        class="form-control color-form-input <?php $__errorArgs = ['secondary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="secondary_color"
                                        id="secondaryColorLabel"
                                        placeholder="Secondary Color"
                                        aria-label="Secondary Color"
                                        value="<?php echo e(old('secondary_color',$basicControl->secondary_color)); ?>">
                                        <?php $__errorArgs = ['secondary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-start">
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="col-lg-4 mb-3 mb-lg-5">
    <div class="card h-100">
        <div class="card-header card-header-content-between">
            <h4 class="card-header-title"><?php echo app('translator')->get('System Control'); ?></h4>
        </div>
        <form action="<?php echo e(route('admin.basic.control.activity.update')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="card-body">
                <ul class="list-group list-group-flush list-group-no-gutters">
                    <li class="list-group-item">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h5 class="mb-0"><?php echo app('translator')->get('Strong Password'); ?></h5>
                                        <span class="d-block fs-6 text-body">
                                            <?php echo app('translator')->get('Create a secure password using our generator tool.'); ?>
                                        </span>
                                    </div>
                                    <div class="col-auto">
                                        <label class="row form-check form-switch mb-3" for="strongPassword">
                                            <span class="col-4 col-sm-3 text-end">
                                                <input type='hidden' value='0' name='strong_password'>
                                                <input
                                                class="form-check-input <?php $__errorArgs = ['strong_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                type="checkbox"
                                                name="strong_password"
                                                id="strongPassword"
                                                value="1" <?php echo e(($basicControl->strong_password == 1) ? 'checked' : ''); ?>>
                                            </span>
                                            <?php $__errorArgs = ['strong_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>

                    <li class="list-group-item">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h5 class="mb-0"><?php echo app('translator')->get('Registration'); ?></h5>
                                        <span class="d-block fs-6 text-body">
                                            <?php echo app('translator')->get('Enable or Disable User Registration'); ?>
                                        </span>
                                    </div>
                                    <div class="col-auto">
                                        <label class="row form-check form-switch mb-3" for="registration">
                                            <span class="col-4 col-sm-3 text-end">
                                                <input type='hidden' value='0' name='registration'>
                                                <input
                                                class="form-check-input <?php $__errorArgs = ['registration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                type="checkbox" name="registration"
                                                id="registration"
                                                value="1" <?php echo e(($basicControl->registration == 1) ? 'checked' : ''); ?>>
                                            </span>
                                            <?php $__errorArgs = ['registration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>

                    <li class="list-group-item">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h5 class="mb-0"><?php echo app('translator')->get('Debug Log'); ?></h5>
                                        <span class="d-block fs-6 text-body">
                                            <?php echo app('translator')->get('Debug logs are generated.'); ?>
                                        </span>
                                    </div>
                                    <div class="col-auto">
                                        <label class="row form-check form-switch mb-3" for="errorLog">
                                            <span class="col-4 col-sm-3 text-end">
                                                <input type='hidden' value='0' name='error_log'>
                                                <input
                                                class="form-check-input <?php $__errorArgs = ['error_log'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                type="checkbox" name="error_log"
                                                id="errorLog"
                                                value="1" <?php echo e(($basicControl->error_log == 1) ? 'checked' : ''); ?>>
                                            </span>
                                            <?php $__errorArgs = ['error_log'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>

                    <!-- List Group Item -->
                    <li class="list-group-item">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h5 class="mb-0"><?php echo app('translator')->get('Cron Pop Up Set'); ?></h5>
                                        <span
                                        class="d-block fs-6 text-body"><?php echo app('translator')->get('Is the active cron pop-up set.'); ?></span>
                                    </div>

                                    <div class="col-auto">
                                        <label class="row form-check form-switch mb-3"
                                        for="isActiveCronNotification">
                                        <span class="col-4 col-sm-3 text-end">
                                           <input type='hidden' value='0' name='is_active_cron_notification'>
                                           <input
                                           class="form-check-input <?php $__errorArgs = ['is_active_cron_notification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           type="checkbox"
                                           name="is_active_cron_notification"
                                           id="isActiveCronNotification"
                                           value="1" <?php echo e(($basicControl->is_active_cron_notification == 1) ? 'checked' : ''); ?>>
                                       </span>
                                       <?php $__errorArgs = ['cron_set_up_pop_up'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                       <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                       <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                   </label>
                               </div>
                           </div>

                       </div>
                   </div>
               </li>

               <li class="list-group-item">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <div class="row align-items-center">
                            <div class="col">
                                <h5 class="mb-0"><?php echo app('translator')->get('Space Between Currency & Amount'); ?></h5>
                                <span
                                class="d-block fs-6 text-body"><?php echo app('translator')->get('The customary currency symbol follows the amount, and is preceded by a space.'); ?></span>
                            </div>
                            <div class="col-auto">
                                <label class="row form-check form-switch mb-3"
                                for="inSpaceBetweenCurrency">
                                <span class="col-4 col-sm-3 text-end">
                                    <input type='hidden' value='0'
                                    name='has_space_between_currency_and_amount'>
                                    <input
                                    class="form-check-input <?php $__errorArgs = ['has_space_between_currency_and_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    type="checkbox"
                                    name="has_space_between_currency_and_amount"
                                    id="inSpaceBetweenCurrency"
                                    value="1" <?php echo e(($basicControl->has_space_between_currency_and_amount == 1) ? 'checked' : ''); ?>>
                                </span>
                                <?php $__errorArgs = ['has_space_between_currency_and_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </li>
        <li class="list-group-item">
            <div class="d-flex">
                <div class="flex-grow-1">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="mb-0"><?php echo app('translator')->get('Currency Position In Left'); ?></h5>
                            <span
                            class="d-block fs-6 text-body"><?php echo app('translator')->get('The currency position can be on the left or right of the amount.'); ?></span>
                        </div>
                        <div class="col-auto">
                            <label class="row form-check form-switch" for="currencyPosition">
                                <span class="col-4 col-sm-3 text-end">
                                    <input type='hidden' value='left' name='is_currency_position'>
                                    <input
                                    class="form-check-input <?php $__errorArgs = ['is_currency_position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    type="checkbox"
                                    name="is_currency_position"
                                    id="is_currency_position"
                                    value="right" <?php echo e(($basicControl->is_currency_position == "right") ? 'checked' : ''); ?>>
                                </span>
                                <?php $__errorArgs = ['is_currency_position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </li>

        <li class="list-group-item">
            <div class="d-flex">
                <div class="flex-grow-1">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="mb-0"><?php echo app('translator')->get('Force SSL'); ?></h5>
                            <span
                            class="d-block fs-6 text-body"><?php echo app('translator')->get('To force the HTTPS connection on your website.'); ?></span>
                        </div>
                        <div class="col-auto">
                            <label class="row form-check form-switch" for="currencyPosition">
                                <span class="col-4 col-sm-3 text-end">
                                    <input type='hidden' value='0' name='is_force_ssl'>
                                    <input
                                    class="form-check-input <?php $__errorArgs = ['force_ssl'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    type="checkbox"
                                    name="is_force_ssl"
                                    id="force_ssl"
                                    value="1" <?php echo e(($basicControl->is_force_ssl == "1") ? 'checked' : ''); ?>>
                                </span>
                                <?php $__errorArgs = ['force_ssl'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </li>

        <li class="list-group-item">
            <div class="d-flex">
                <div class="flex-grow-1">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="mb-0"><?php echo app('translator')->get('Gateway Auto Update Currency'); ?></h5>
                            <span
                            class="d-block fs-6 text-body"><?php echo app('translator')->get('This feature automates currency rate updates in a payment gateway.'); ?></span>
                        </div>
                        <div class="col-auto">
                            <label class="row form-check form-switch" for="gatewayCurrencyUpdate">
                                <span class="col-4 col-sm-3 text-end">
                                    <input type='hidden' value='0' name='automatic_currency_update_permission'>
                                    <input
                                    class="form-check-input <?php $__errorArgs = ['automatic_currency_update_permission'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    type="checkbox"
                                    name="automatic_currency_update_permission"
                                    id="automatic_currency_update_permission"
                                    value="1" <?php echo e(($basicControl->automatic_currency_update_permission == "1") ? 'checked' : ''); ?>>
                                </span>
                                <?php $__errorArgs = ['automatic_currency_update_permission'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </li>

        <li class="list-group-item">
            <div class="d-flex">
                <div class="flex-grow-1">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="mb-0"><?php echo app('translator')->get('Ecommerce Status'); ?></h5>
                            <span
                            class="d-block fs-6 text-body"><?php echo app('translator')->get('If you want to enable E-commerce shop in your site then turn on this button.'); ?></span>
                        </div>
                        <div class="col-auto">
                            <label class="row form-check form-switch" for="ecommerce_status">
                                <span class="col-4 col-sm-3 text-end">
                                    <input type='hidden' value='0' name='ecommerce_status'>
                                    <input
                                    class="form-check-input <?php $__errorArgs = ['ecommerce_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    type="checkbox"
                                    name="ecommerce_status"
                                    id="ecommerce_status"
                                    value="1" <?php if($basicControl->ecommerce): echo 'checked'; endif; ?>>
                                </span>
                                <?php $__errorArgs = ['ecommerce_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </label>

                        </div>
                    </div>
                </div>
            </div>
        </li>

        <div class="d-flex justify-content-start mt-3">
            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
        </div>
    </ul>
</div>
</form>
</div>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js-lib'); ?>
<script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    'use strict';
    $( document ).ready(function() {
        HSCore.components.HSTomSelect.init('.js-select', {
            maxOptions: 500
        })
    })
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/control_panel/basic_control.blade.php ENDPATH**/ ?>