
<?php $__env->startSection('page_title', __('Overview')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title"><?php echo app('translator')->get('Mining Reward'); ?></h1>
            </div>
            <div class="col-sm-auto">
                <a href="<?php echo e(route('admin.monthly.plan.index')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Back to List'); ?></a>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <div class="row">
        <div class="col-lg-12">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title"><?php echo app('translator')->get('Mining Reward'); ?></h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive" style="overflow-x: auto;">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Customer ID'); ?></th>
                                    <th><?php echo app('translator')->get('Customer Name'); ?></th>
                                    <th><?php echo app('translator')->get('Plan'); ?></th>
                                    <th><?php echo app('translator')->get('Quantity'); ?></th>
                                    <th><?php echo app('translator')->get('Purchased At'); ?></th>
                                    <th><?php echo app('translator')->get('Start Date'); ?></th>
                                    <th><?php echo app('translator')->get('End Date'); ?></th>
                                    <th><?php echo app('translator')->get('Days Vested'); ?></th>
                                    <th><?php echo app('translator')->get('Hash Rate'); ?></th>
                                    <th><?php echo app('translator')->get('Mining Reward'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $processedInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($investment['user_id']); ?></td>
                                    <td><?php echo e($investment['user_name']); ?></td>
                                    <td>
                                        <?php
                                        $plan = \App\Models\InvestmentPlan::find($investment['planId']);
                                        ?>
                                        <?php echo e($plan->plan_name ?? 'N/A'); ?>

                                    </td>                                   
                                    <td><?php echo e($investment['quantity']); ?></td>
                                    <td><?php echo e($investment['purchased_date']); ?></td>
                                    <td><?php echo e($investment['effective_start_date']); ?></td>
                                    <td><?php echo e($investment['effective_end_date']); ?></td>
                                    <td><?php echo e($investment['days_invested']); ?></td>
                                    <td><?php echo e($investment['hashrate']); ?></td>
                                    <td><?php echo e($investment['calculated_reward']); ?></td>
                                    <td>Pending</td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
<!--                             <tfoot>
                                <tr class="table-primary">
                                    <th style="background: #3F51B5 !important;color: #ffffff;"  colspan="3"><?php echo app('translator')->get('Total'); ?></th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;" ><?php echo e($summary['total_quantity']); ?></th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;"  colspan="4"></th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;" ><?php echo e($summary['total_reward']); ?></th>
                                </tr>
                            </tfoot> -->
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_config/summary.blade.php ENDPATH**/ ?>