<?php if(auth()->user()): ?>
<?php $layout = 'user' ?>
<?php else: ?>
<?php $layout = 'payment' ?>
<?php endif; ?>



<?php $__env->startSection('title', __('Pay with PAYPAL')); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h3 class="mb-1"><?php echo e(__('Pay with ').__(optional($deposit->gateway)->name)); ?></h3>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(__('Pay with ').__(optional($deposit->gateway)->name)); ?></li>
        </ol>
    </nav>
</div>
<div class="container-fluid mt-lg-5">
    <div class="container add-fund">
        <div class="row justify-content-center">
            <div class="col-md-7">
                <div class="card custom-card pt-3" style="    background-color: white;">
                    <div class="card-body">
                        <div id="paypal-button-container"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://www.paypal.com/sdk/js?client-id=<?php echo e($data->cleint_id); ?>">
</script>
<script>
    paypal.Buttons({
        createOrder: function (data, actions) {
            return actions.order.create({
                purchase_units: [
                    {
                        description: "<?php echo e($data->description); ?>",
                        custom_id: "<?php echo e($data->custom_id); ?>",
                        amount: {
                            currency_code: "<?php echo e($data->currency); ?>",
                            value: "<?php echo e($data->amount); ?>",
                            breakdown: {
                                item_total: {
                                    currency_code: "<?php echo e($data->currency); ?>",
                                    value: "<?php echo e($data->amount); ?>"
                                }
                            }
                        }
                    }
                ]
            });
        },
        onApprove: function (data, actions) {
            return actions.order.capture().then(function (details) {
                var trx = "<?php echo e($data->custom_id); ?>";
                window.location = '<?php echo e(url('payment/paypal')); ?>/' + trx + '/' + details.id
            });
        }
    }).render('#paypal-button-container');
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.'.$layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/user/payment/paypal.blade.php ENDPATH**/ ?>