
<?php $__env->startSection('title',trans('Referral Bonus')); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h3 class="mb-1"><?php echo app('translator')->get('Referral Bonus'); ?></h3>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                <li class="breadcrumb-item active"><?php echo app('translator')->get('Referral Bonus'); ?></li>
            </ol>
        </nav>
    </div>

    <div class="card mt-50">
        <div class="card-header btn-area d-flex justify-content-end">
            <button type="button" class="btn-custom btn-white btn-custom-sm" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSearch" aria-controls="offcanvasExample"><i class="fa-light fa-search me-1"></i><?php echo app('translator')->get('Filter'); ?> <span></span> </button>
        </div>
        <div class="card-body">
            <div class="cmn-table">
                <div class="table-responsive">
                    <table class="table align-middle">
                        <thead>
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('SL'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Bonus From'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Type'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Level'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Remarks'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Date'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e($referrals->firstItem()+$key); ?></td>
                                <td data-label="<?php echo app('translator')->get('Bonus From'); ?>"><?php echo e($value->bonusBy->username); ?></td>
                                <td data-label="<?php echo app('translator')->get('Amount'); ?>" class="text-success"><?php echo e(currencyPosition($value->amount)); ?></td>
                                <td data-label="<?php echo app('translator')->get('Type'); ?>"><?php echo e(trans(snake2Title($value->commission_type))); ?></td>
                                <td data-label="<?php echo app('translator')->get('Level'); ?>"><?php echo app('translator')->get('Level'); ?> <?php echo e($value->level); ?></td>
                                <td data-label="<?php echo app('translator')->get('Remarks'); ?>"><?php echo e(trans($value->remarks)); ?></td>
                                <td data-label="<?php echo app('translator')->get('Date'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
                <?php if(count($referrals??[]) == 0): ?>
                    <div class="row d-flex text-center justify-content-center">
                        <div class="col-4">
                            <img src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" id="no-data-image" class="no-data-image" alt="" srcset="">
                            <p><?php echo app('translator')->get('No data to show'); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
    <div class="pagination-section">
        <nav aria-label="...">
            <?php echo e($referrals->appends($_GET)->links($theme.'partials.user-pagination')); ?>

        </nav>
    </div>

    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasSearch" aria-labelledby="offcanvasExampleLabel" aria-modal="true" role="dialog">
        <div class="offcanvas-header d-flex justify-content-between">
            <h5 class="offcanvas-title" id="offcanvasExampleLabel me-2"><?php echo app('translator')->get('Referral Bonus Filter'); ?></h5>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fa-light fa-arrow-right"></i>
            </button>
        </div>
        <div class="offcanvas-body">
            <form action="<?php echo e(route('user.referral.bonus')); ?>" method="GET">
                <div class="row g-4">
                    <div>
                        <label for="Title" class="form-label"><?php echo app('translator')->get('Bonus Type'); ?></label>
                        <input placeholder="Bonus Type" name="type"  type="text" class="form-control form-control-sm">
                    </div>
                    <div>
                        <label for="Title" class="form-label"><?php echo app('translator')->get('Remark'); ?></label>
                        <input placeholder="Remark" name="remark"  type="text" class="form-control form-control-sm">
                    </div>
                    <div>
                        <label for="CreatedAt" class="form-label"> <?php echo app('translator')->get('Date Range'); ?> </label>
                        <input type="text" name="date_range" class="form-control date flatpickr-input active"  readonly="readonly" placeholder="<?php echo app('translator')->get('Select Dates'); ?>">
                    </div>

                    <div class="btn-area">
                        <button type="submit" class="btn-1"> <i class="fa-light fa-search me-1"></i><?php echo app('translator')->get('Apply'); ?> <span></span> </button>
                    </div>
                </div>

            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        flatpickr(".date",{
            mode: "range",
        });
    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/user/referral/referral_bonus.blade.php ENDPATH**/ ?>