<?php $__env->startSection('title',trans('Affiliate')); ?>

<?php $__env->startPush('style'); ?>
<style>
    .common-item {
        background-color: #0a202d;
        border: 1px solid #195273;
        border-radius: 12px;
        padding: 1.2rem;
    }

    .common-item h6 {
        border-left: 4px solid #0e73e4;
    }

    .common-item .agent {
        background-color: rgba(27, 64, 37, 0.8);
        border-left: 8px solid #5ad57b;
        border-right: 8px solid #5ad57b;
        border-radius: 12px;
        padding: 0.8rem 1rem;
    }

    .common-item .badge {
        background-color: rgba(27, 64, 37, 0.8);
        border-radius: 15px;
        color: #5ad57b !important;
        padding: 0.6rem 0.8rem 0.6rem 0.8rem !important;
    }

    .common-item .badge .fa-circle {
        color: #5ad57b !important;
    }

    .common-item .copy-link {
        background-color: #0f3246;
        border: 1px solid #195273;
        border-radius: 8px;
        padding: 0.8rem 1rem;
        color: white;
        gap: 0.5rem;
    }

    .common-item .copy-link input {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        width: 100%;
        pointer-events: none;
        font-weight: 600;
    }

    .common-item .copy-btn {
        display: flex;
        justify-content: center;
        align-items: center;
        background-color: #0e73e4;
        border-radius: 8px;
        padding: 0.5rem;
        color: white;
        font-size: 12px;
        width: max-content;
        pointer-events: auto;
        cursor: pointer;
        white-space: nowrap;
        flex-shrink: 0;
    }

    .common-item .referral-first-copy {
        margin: 0.7rem 0 !important;
        font-size: 12px;
        text-align: center;
    }

    .common-item .referral-second-copy {
        margin-left: 0.1rem !important;
        font-size: 14px;
    }

    .table-container {
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    .referral-table {
        min-width: 370px;
    }

    .referral-table>* {
        color: white;
        table-layout: auto;
        width: 100%;
    }

    .referral-table tbody tr:not(:last-child) td {
        padding-bottom: 0.5rem;
    }

    /* .referral-table tbody tr td:nth-child(2) {
        min-width: 80px
    } */

    .referral-table tbody tr td:last-child {
        display: flex;
        justify-content: end;
        align-items: center;
        white-space: nowrap;
        flex-shrink: 0;
    }

    /* .referral-table .first-col {
        padding-right: 5px;
        width: 100%;
    } */

    .referral-table .border-right {
        border-right: 1px solid #ccc;
        padding-right: 10px;
        font-size: 12px;
        text-align: right;
    }

    .referral-table .currency {
        text-align: center;
        font-size: 12px;
        padding-top: 0.2rem;
        /* min-width: 50px; */
    }

    .referral-table .currency img {
        width: 12px;
        margin-right: 0.3rem;
    }

    .referral-table .referral-badge {
        background-color: rgba(27, 64, 37, 0.7);
        border-radius: 15px;
        padding: 0.2rem 0.55rem;
        color: #5ad57b !important;
        font-size: 14px;
        font-weight: 800;
    }

    .filter-btn {
        color: white;
        border-radius: 10px;
        background-color: #0f3246;
        padding: 0.5rem 0.9rem;
        pointer-events: auto;
        cursor: pointer;
    }

    .filter-btn img {
        margin-right: 0.6rem;
    }

    .filter-item {
        background-color: #0f3246;
        color: white;
        border-radius: 12px;
        font-size: 14px;
        padding: 0.7rem 1rem;
        width: 100%;
        text-align: center;
        font-weight: 700;
    }

    .filter-item.active {
        background-color: #0e73e4;
    }

    .filter-date {
        padding: 0.8rem 1rem;
        border-radius: 10px;
    }

    .referral-listing {
        color: white;
        background-color: #0a202d;
        border: 1px solid #195273;
        border-radius: 12px;
        border-collapse: separate;
        border-spacing: 0;
        overflow: hidden;
        margin-bottom: 10px;
    }

    .listing-container {
        overflow-x: scroll;
    }

    .listing-container::-webkit-scrollbar {
        width: 10px;
        height: 5px;
    }

    .listing-container::-webkit-scrollbar-thumb {
        background-color: #0e73e4;
        border-radius: 5px;
    }

    .listing-container::-webkit-scrollbar-track {
        background-color: #e0e0e0; 
        border-radius: 5px;
    }

    #referral-subrows,
    #nested-subrows,
    #referral-subrows tbody tr td,
    #nested-subrows tbody tr td {
        background-color: #0c2737;
        color: white;
        border: none;
    }

    .referral-listing thead tr th,
    .referral-listing tbody tr td {
        padding: 1rem 1.5rem;
        white-space: nowrap;
    }

    .referral-listing tbody tr td:first-child {
        padding: 1rem 1rem 1rem 1.5rem;
    }

    .referral-listing tbody tr {
        background-color: #0c2737;
    }

    .referral-username {
        word-break: break-all;
    }

    .referral-username.indent-level-2 {
        padding-left: 2rem !important;
    }

    .referral-username.indent-level-3 {
        padding-left: 2.8rem !important;
    }

    .text-success {
        color: #5ad57b !important
    }

    .submit-btn {
        background: rgb(3, 37, 146);
        background: linear-gradient(90deg, rgba(3, 37, 146, 1) 0%, rgba(14, 115, 228, 1) 50%);
        color: white;
        border-radius: 10px;
        padding: 0.8rem 0;
        font-size: 16px;
    }

    #filterModal .modal-dialog {
        max-width: 390px;
    }

    .popover {
        border: 1.5px solid #195273;
        background-color: #0f3246;
        border-radius: 8px;
        margin-bottom: 0.25rem !important;
    }

    .popover-body {
        color: white !important;
        font-weight: 600;
    }

    .bs-popover-auto[data-popper-placement^=top]>.popover-arrow::before,
    .bs-popover-top>.popover-arrow::before,
    .bs-popover-auto[data-popper-placement^=top]>.popover-arrow::after,
    .bs-popover-top>.popover-arrow::after {
        border-top-color: #0f3246;
    }

    .common-item .pending-badge {
        background-color: #4A2C08;
        color: #F7931A !important;
    }

    .common-item .pending-badge .fa-circle {
        color: #F7931A !important;
    }

    .common-item .qualified-badge {
        background-color: #1B4025;
        color: #5AD57B !important;
    }

    .common-item .qualified-badge .fa-circle {
        color: #5AD57B !important;
    }

    .common-item a {
        color: #F7931A;
        font-size: 14px;
        font-weight: bold;
    }

</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div class="pagetitle">

    <h3 class="mb-1 font-bold text-center"><?php echo app('translator')->get('Affiliate Program'); ?></h3>

    <!-- <nav>

            <ol class="breadcrumb">

                <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>

                <li class="breadcrumb-item active"><?php echo app('translator')->get('Referral'); ?></li>

            </ol>

        </nav> -->

    </div>

<!-- main -->

<div class="container-fluid">

    <div class="main row g-4 d-flex justify-content-center">

        <div class="col-12 col-lg-7 col-xl-6">

            <div class="common-item mb-4">
                <?php if ($verify) { ?>
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h6 class="ps-2 text-white font-bold">Agent Status</h6>
                        <span class="badge qualified-badge"><i class="fa-solid fa-circle fa-sm me-1"></i> Qualified</span>
                    </div>

                    <div class="d-flex justify-content-between align-items-center agent mb-1 text-white">
                        All tasks are completed and now you're qualified
                    </div>
                <?php } else { ?>
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h6 class="ps-2 text-white font-bold">Agent Status</h6>
                        <span class="badge pending-badge"><i class="fa-solid fa-circle fa-sm me-1"></i> Pending</span>
                    </div>

                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <p class="m-0">Book Training</p>
                        </div>

                        <a href="">Start <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                    </div>
                <?php } ?>

            </div>


            <div class="common-item mb-4">
                <h6 class="mb-4 ps-2 text-white font-bold">Referral Code</h6>

                <!-- Link copy -->
                <div id="copyLinkContainer" class="d-flex justify-content-between align-items-center copy-link mb-2" data-bs-toggle="popover" data-bs-trigger="manual" data-bs-placement="top" data-bs-content="Copied to clipboard">
                    <input type="text" class="border-0 bg-transparent text-white" value="https://petarig.fireworksmedia.com/project/register?ref=<?php echo e($referral_code); ?>" readonly id="refLink">
                    <div id="copyLinkBtn" class="copy-btn">
                        <i class="fa-regular fa-clone fa-rotate-180 fa-sm ps-2"></i>
                        Copy Link
                    </div>
                </div>

                <p class="m-0 my-2 referral-first-copy">or you can copy the code below</p>

                <!-- Code copy -->
                <div id="copyCodeContainer" class="d-flex justify-content-between align-items-center copy-link mb-3" data-bs-toggle="popover" data-bs-trigger="manual" data-bs-placement="top" data-bs-content="Copied to clipboard">
                    <input type="text" class="border-0 bg-transparent text-white" value="<?php echo e($referral_code); ?>" readonly id="refCode">
                    <div id="copyCodeBtn" class="copy-btn">
                        <i class="fa-regular fa-clone fa-rotate-180 fa-sm ps-2"></i>
                        Copy
                    </div>
                </div>

                <p class="mb-0 referral-second-copy">Refer your friends and earn commission</p>
            </div>


            <div class="common-item mb-3" style="overflow-x: hidden;">
                <h6 class="mb-4 ps-2 text-white font-bold">Affiliate Program</h6>

                <p class="mb-4" style="font-size: 14px;">
                    Our affiliate model reward users for referring others to the platform across three levels. 
                    Percentage commission earned at each level are as follows:
                </p>

                <div class="table-container">
                    <table class="referral-table w-100 mb-1">
                        <colgroup>
                            <col style="width: 60%">
                            <col style="width: 20%">
                            <col style="width: 20%">
                        </colgroup>
                        <tbody>
                            <tr>
                                <td class="first-col">
                                    Level 1
                                    <span class="referral-badge ms-1"><?php echo e($lvl1percentage); ?>%</span>
                                </td>
                                <td>
                                    <div class="border-right">
                                        <?php echo e($lvl1); ?> referrals
                                        <div>
                                        </td>
                                        <td class="font-bold d-flex justify-content-end align-items-center currency">
                                            <img src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                            <span><?php echo e($lvl1_total); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="first-col">
                                            Level 2
                                            <span class="referral-badge ms-1"><?php echo e($lvl2percentage); ?>%</span>
                                        </td>
                                        <td>
                                            <div class="border-right">
                                                <?php echo e($lvl2); ?> referrals
                                                <div>
                                                </td>
                                                <td class="font-bold d-flex justify-content-end align-items-center currency">
                                                    <img src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                                    <span><?php echo e($lvl2_total); ?></span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="first-col">
                                                    Level 3
                                                    <span class="referral-badge ms-1"><?php echo e($lvl3percentage); ?>%</span>
                                                </td>
                                                <td>
                                                    <div class="border-right">
                                                        <?php echo e($lvl3); ?> referrals
                                                        <div>
                                                        </td>
                                                        <td class="font-bold d-flex justify-content-end align-items-center currency">
                                                            <img src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                                            <span><?php echo e($lvl3_total); ?></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center mt-4 mb-3">
                                        <p class="m-0 ms-1">Last referrals</p>
                                        <div class="d-flex align-items-center filter-btn d-none" data-bs-toggle="modal" data-bs-target="#filterModal" role="button">
                                            <img src="<?php echo e(asset('assets/themes/light/images/icons/FilterIcon.svg')); ?>" alt="" />
                                            Filter
                                        </div>
                                    </div>

                                    <div class="modal fade" id="filterModal" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content bg-dark text-white border-0 rounded-3">
                                                <div class="modal-body p-0">
                                                    <div class="common-item">
                                                        <h6 class="mb-3 ps-2 text-white font-bold">Filter Transactions</h6>

                                                        <div class="d-flex justify-content-between align-items-center mb-3 gap-2">
                                                            <div class="filter-item">All Time</div>
                                                            <div class="filter-item">Last Month</div>
                                                            <div class="filter-item">Pick Date</div>
                                                        </div>

                                                        <input type="date" class="w-100 border-0 filter-date mt-3" />

                                                        <div class="btn-area d-flex mt-5">

                                                            <button type="button" class="btn-2 submit-btn w-100 d-flex justify-content-center font-bold"><?php echo app('translator')->get('Apply Filter'); ?> <span></span></button>

                                                        </div>

                                                        <div class="btn-area d-flex">

                                                            <button type="button" class="cancel-btn text-white w-100 d-flex justify-content-center font-bold pt-3"><?php echo app('translator')->get('Cancel'); ?> <span></span></button>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <!-- Wrapper for scroll -->
                                    <div class="listing-container">
                                        <table class="referral-listing w-100">
                                            <thead>
                                                <tr>
                                                    <th>Username</th>
                                                    <th>Email</th>
                                                    <th>Level</th>
                                                    <th>Commission</th>
                                                    <th>Date Purchased</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <?php $__currentLoopData = $referral_structure; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $level1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <!-- Level 1 -->
                                                <tr data-bs-toggle="collapse" data-bs-target=".referral-subrows-<?php echo e($index); ?>" style="cursor: pointer;">
                                                    <td class="referral-username">
                                                        <?php echo e($level1['username']); ?>

                                                        <i class="fa-solid fa-caret-down ms-2"></i>
                                                    </td>
                                                    <td><?php echo e($level1['email']); ?></td>
                                                    <td>Level 1</td>
                                                    <td class="d-flex align-items-center text-success">
                                                        <img class="me-2" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                                        <?php echo e(number_format($level1['commission'], 4)); ?>

                                                    </td>
                                                    <td><?php echo e($level1['date'] !== '' ? $level1['date'] : 'N/A'); ?></td>
                                                </tr>

                                                <?php $__currentLoopData = $level1['level2']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l2index => $level2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <!-- Level 2 -->
                                                <tr class="collapse referral-subrows-<?php echo e($index); ?>" data-bs-toggle="collapse" data-bs-target=".referral-subrows-<?php echo e($index); ?>-<?php echo e($l2index); ?>">
                                                    <td class="referral-username indent-level-2">
                                                        <?php echo e($level2['username']); ?>

                                                        <i class="fa-solid fa-caret-down ms-2"></i>
                                                    </td>
                                                    <td><?php echo e($level2['email']); ?></td>
                                                    <td>Level 2</td>
                                                    <td class="d-flex align-items-center text-success">
                                                        <img class="me-2" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                                        <?php echo e(number_format($level2['commission'], 4)); ?>

                                                    </td>
                                                    <td><?php echo e($level2['date'] !== '' ? $level2['date'] : 'N/A'); ?></td>
                                                </tr>

                                                <?php $__currentLoopData = $level2['level3']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <!-- Level 3 -->
                                                <tr class="collapse referral-subrows-<?php echo e($index); ?>-<?php echo e($l2index); ?>">
                                                    <td class="referral-username indent-level-3"><?php echo e($level3['username']); ?></td>
                                                    <td><?php echo e($level3['email']); ?></td>
                                                    <td>Level 3</td>
                                                    <td class="d-flex align-items-center text-success">
                                                        <img class="me-2" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                                        <?php echo e(number_format($level3['commission'], 4)); ?>

                                                    </td>
                                                    <td><?php echo e($level3['date'] !== '' ? $level3['date'] : 'N/A'); ?></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>

                                        </table>
                                    </div>

                                </div>

                            </div>

                        </div>
                    </div>



                    <?php $__env->stopSection(); ?>





                    <?php $__env->startPush('script'); ?>

                    <script>
                        'use strict'

                        $(document).on('click', '.nextDirectReferral', function() {

                            let _this = $(this);

                            let parentRow = _this.closest('tr');



        // Check if the downline is already loaded

                            if (parentRow.data('loaded')) {

                                return;

                            }



                            getDirectReferralUser(_this);

                        });



                        function getDirectReferralUser(_this) {



                            Notiflix.Block.standard('.block-statistics');



                            let userId = _this.data('id');

                            let parentRow = _this.closest('tr');

                            let currentLevel = parseInt(parentRow.data('level')) + 1;

                            let downLabel = currentLevel + 1;



                            setTimeout(function() {

                                $.ajaxSetup({

                                    headers: {

                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                                    }

                                });



                                $.ajax({

                                    url: "<?php echo e(route('user.myGetDirectReferralUser')); ?>",

                                    method: 'POST',

                                    data: {

                                        userId: userId,

                                    },

                                    success: function(response) {



                                        Notiflix.Block.remove('.block-statistics');

                                        let directReferralUsers = response.data;



                                        let referralData = '';



                                        directReferralUsers.forEach(function(directReferralUser) {

                                            referralData += `

                        <tr id="user-${directReferralUser.id}" data-level="${currentLevel}">

                            <td data-label="<?php echo app('translator')->get('Username'); ?>" style="padding-left: ${currentLevel * 35}px;">

                                <a class="${directReferralUser.count_direct_referral > 0 ? 'nextDirectReferral' : ''}" href="javascript:void(0)" style="border-bottom: none !important;" data-id="${directReferralUser.id}">

                                    ${directReferralUser.count_direct_referral > 0 ? ' <i class="far fa-circle-down color-primary"></i>' : ''}

                                    ${directReferralUser.username}

                                </a>

                            </td>



                            <td data-label="<?php echo app('translator')->get('Level'); ?>">

                                 <span class="text-dark">Level ${downLabel}</span>

                            </td>



                            <td data-label="<?php echo app('translator')->get('Email'); ?>">

                                ${directReferralUser.email ? directReferralUser.email : '-'}

                            </td>

                            <td data-label="<?php echo app('translator')->get('Phone Number'); ?>">

                                 ${directReferralUser.phone??'-'}

                            </td>



                            <td data-label="Joined At">

                                ${directReferralUser.joined_at}

                            </td>

                                                </tr>`;

                                            });



                    // Mark this row as having its downline loaded

                                        parentRow.data('loaded', true);



                                        $(`#user-${userId}`).after(referralData);

                                    },

                                    error: function(xhr, status, error) {

                                        console.log(error);

                                    }

                                });

                            }, 100);

                        }
                    </script>

                    <script>
                        $('#socialShare').socialSharingPlugin({

                            url: '<?php echo e(route('register',['ref' => $referral_code])); ?>',

                            title: 'join and enjoy',

                            description: $('meta[property="og:description"]').attr('content'),

                            img: $('meta[property="og:image"]').attr('content'),

                            enable: ['facebook', 'whatsapp', 'twitter', 'email', 'linkedin', 'pinterest', 'reddit', 'telegram']

                        });



                        function copyFunction() {

                            var copyText = document.getElementById("referralURL");

                            copyText.select();

                            copyText.setSelectionRange(0, 99999);

        /*For mobile devices*/

                            document.execCommand("copy");

                            Notiflix.Notify.success(`Copied: ${copyText.value}`);

                        }



                        $(document).ready(function() {

                            // Notiflix.Block.standard('#depositPayoutHistoryCard');





                            var depositPayoutChartOptions = {

                                series: [{

                                    name: "Bonus",

                                    data: []

                                }

                            ],

                            chart: {

                                height: 410,

                                type: 'line',

                                zoom: {

                                    enabled: false

                                },

                                toolbar: {

                                    show: false,



                                }

                            },

                            dataLabels: {

                                enabled: false

                            },

                            stroke: {

                                curve: 'smooth'

                            },



                            grid: {

                                row: {

                    colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns

                    opacity: 0.5

                },

            },

            xaxis: {

                categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],

            },

            colors: ['#5B8FF9', '#6C757D'],

            tooltip: {

                y: {

                    formatter: function(val) {

                        return currencyPosition(val)

                    }

                }

            }

        };



        const depositPayoutChart = new ApexCharts(document.querySelector("#depositPayoutHistory"), depositPayoutChartOptions);

        // depositPayoutChart.render();

        // depositPayoutHistory();



        async function depositPayoutHistory() {

            await axios.get('<?php echo e(route('user.referral.bonus.history')); ?>')

            .then(function(response) {

                let newSeries = [{

                    name: 'Bonus',

                    data: response.data.referrals

                }];

                depositPayoutChart.updateSeries(newSeries)

                Notiflix.Block.remove('#depositPayoutHistoryCard');

            })

            .catch(function(error) {



            })

        }



    })

                        $(document).ready(function() {
                            $('.filter-date').hide();

                            $('.filter-item').on('click', function() {
                                $('.filter-item').removeClass('active');
                                $(this).addClass('active');

                                const text = $(this).text().trim().toLowerCase();
                                if (text === 'pick date') {
                                    $('.filter-date').slideDown();
                                } else {
                                    $('.filter-date').slideUp();
                                }
                            });

                            $('.submit-btn, .cancel-btn').on('click', function() {
                                $('#filterModal').modal('hide');
                            });

        // Initialize Bootstrap popovers
                            var linkPopover = new bootstrap.Popover($('#copyLinkContainer')[0]);
                            var codePopover = new bootstrap.Popover($('#copyCodeContainer')[0]);

        // Copy link
                            $('#copyLinkBtn').on('click', function() {
                                var link = $('#refLink').val();
                                navigator.clipboard.writeText(link).then(function() {
                                    linkPopover.show();
                                    setTimeout(() => linkPopover.hide(), 1000);
                                });
                            });

        // Copy code
                            $('#copyCodeBtn').on('click', function() {
                                var code = $('#refCode').val();
                                navigator.clipboard.writeText(code).then(function() {
                                    codePopover.show();
                                    setTimeout(() => codePopover.hide(), 1000);
                                });
                            });
                        });
                    </script>

                    <?php $__env->stopPush(); ?>
<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/user/referral/referral-program.blade.php ENDPATH**/ ?>