@extends($theme.'layouts.user')

@section('title', __('Manage Wallet'))

@push('style')

<style>
    .wallet-info {
        background-color: #4A2C08;
        border-left: 8px solid #F7931A;
        border-radius: 12px;
        padding: 1.3rem 0.8rem 1.2rem 0.8rem;
    }

    .wallet-info img {
        background-color: rgba(247, 147, 26, 0.2);
        border-radius: 100%;
        padding: 0.35rem;
    }

    .wallet-address {
        background-color: #0f3246 !important;
        border: 1px solid #195273 !important;
        border-radius: 10px;
        padding: 1rem;
        color: white !important;
    }

    .wallet-address::placeholder {
        color: white;
    }

    .new-address {
        background-color: rgba(14, 115, 228, 0.2);
        border-radius: 5px;
        padding: 0.5rem 0.7rem;
        width: max-content;
        pointer-events: auto;
        cursor: pointer;
    }

    .new-address p {
        color: #0e73e4;
    }

    #walletModal .modal-body {
        border-radius: 15px;
        padding: 2rem;
    }

    #updateBtn,
    #addBtn {
        width: 150px;
        height: 40px;
        font-weight: 600;
    }
</style>

@endpush

@section('content')

<div class="container">

    <div class="row d-flex justify-content-center">

        <div class="col-12 col-md-8">
            <h3 class="mt-3 mb-5 text-center font-bold">Manage Your Wallet</h3>



            <!-- Display Success and Error Messages -->

            @if(session('success'))

            <div class="alert alert-success">{{ session('success') }}</div>

            @elseif(session('error'))

            <div class="alert alert-danger">{{ session('error') }}</div>

            @endif


            <div class="wallet-info mb-4">
                <div class="d-flex align-items-center mb-3">
                    <img src="{{ asset('assets/themes/light/images/icons/Info.svg') }}" alt="Info icon" />
                    <p class="m-0 ms-2 font-bold">Important</p>
                </div>

                <p>
                    Please ensure that you provide a wallet address that is able to receive Dogecoin.
                    We will not be held responsible if the distribution of dogecoin is lost due to an invalid wallet address.
                </p>
            </div>


            <!-- Add/Edit Wallet Address Form -->

            <!-- <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                    <p class="m-0 ms-2">Dogecoin</p>
                </div>

                <div class="d-flex align-items-center new-address" data-bs-toggle="modal" data-bs-target="#walletModal">
                    <img src="{{ asset('assets/themes/light/images/icons/PlusIcon.svg') }}" alt="Plus icon" />
                    <p class="m-0 ms-2">Add New Address</p>
                </div>

            </div>

            <div>
                <input type="text" class="form-control wallet-address mb-3" placeholder="Please Fill In Wallet Address" required>
            </div> -->

            @foreach($walletTypes as $walletType)
            @php
            $userWallet = $walletAddresses->firstWhere('type', $walletType->id);
            @endphp

            <div class="wallet-type-wrapper mb-4">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="d-flex align-items-center">
                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                        <p class="m-0 ms-2">{{ $walletType->name }}</p>
                    </div>

                    <!-- <div class="d-flex align-items-center new-address" data-bs-toggle="modal" data-bs-target="#walletModal">
                            <img src="{{ asset('assets/themes/light/images/icons/PlusIcon.svg') }}" alt="Plus icon" />
                            <p class="m-0 ms-2">
                                {{ $userWallet ? 'Edit Wallet Address' : 'Add New Address' }}
                            </p>
                        </div> -->
                    </div>

                    <form id="addWallet" action="{{ route('user.wallet.store') }}" method="POST">

                        @csrf

                        <div>
                            <input
                            type="text"
                            class="form-control wallet-address mb-2"
                            name="address[]"
                            id="wallet_address[{{ $walletType->id }}]"
                            value="{{ $userWallet ? $userWallet->address : '' }}"
                            placeholder="Wallet Address"
                            {{ $userWallet ? 'readonly' : '' }}>

                            <div class="error-message text-danger d-none mb-2 ms-1" style="font-size: 14px;margin-bottom: 0.5rem !important;"></div>

                            <input type="hidden" name="wallet_type" value="{{ $walletType->id }}">

                            @error('address')
                            <span class="text-danger mb-2">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="d-flex align-items-center new-address mx-auto">
                            <img src="{{ asset('assets/themes/light/images/icons/VideoIcon.svg') }}" alt="Plus icon" />
                            <a href="https://youtu.be/RDOFtc3aee0" target="_blank" class="m-0 ms-2 text-decoration-none" style="color:white">
                              Watch this tutorial video
                          </a>

                      </div>

                      <div class="d-flex justify-content-center">
                        @if ($userWallet)
                        <!-- If there's already an address, this button will update it -->
                        <button type="button" data-bs-toggle="modal" data-bs-target="#walletModal" class="btn btn-warning mt-4 d-flex flex-column justify-content-center align-items-center">
                            <span class="btn-text text-dark">Update Address</span>
                        </button>
                        @else
                        <!-- Otherwise, this button will add the address -->
                        <button id="addBtn" type="submit" form="addWallet" class="submit-button btn btn-primary mt-4 d-flex flex-column justify-content-center align-items-center">
                            <div class="spinner-border spinner-border-sm text-white d-none" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <span class="btn-text text-white">Add Address</span>
                        </button>
                        @endif
                    </div>
                </form>
            </div>
            @endforeach

            <!-- Modal -->
            <div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content" style="background: #071720;">
                        <div class="modal-body" style="background: #071720;">
                            <h3 class="text-center font-bold">Edit Wallet Address</h3>
                            
                            <form id="updateWallet" action="{{ route('user.wallet.store') }}" method="POST">
                                @csrf

                                @foreach($walletTypes as $walletType)
                                <div class="mb-3 d-flex flex-column">
                                    <label for="wallet_type_{{ $walletType->id }}" class="text-white d-flex justify-content-center align-items-center mb-4">
                                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" alt="Wallet Type Icon" class="me-2" />
                                        {{ $walletType->name }}
                                    </label>

                                    @php
                                    $userWallet = $walletAddresses->firstWhere('type', $walletType->id);
                                    @endphp

                                    <input type="text" name="address[]" id="wallet_type_{{ $walletType->id }}" class="form-control wallet-address mb-2"
                                    value="{{ $userWallet ? $userWallet->address : '' }}"
                                    placeholder="Enter wallet address">

                                    <div class="error-message text-danger d-none mb-2 ms-1" style="font-size: 14px;"></div>

                                    <input type="hidden" name="wallet_type" value="{{ $walletType->id }}">

                                    <div class="d-flex align-items-center new-address mx-auto">
                                        <img src="{{ asset('assets/themes/light/images/icons/VideoIcon.svg') }}" alt="Plus icon" />
                                        <a href="https://youtu.be/RDOFtc3aee0" target="_blank" class="m-0 ms-2 text-decoration-none" style="color:white">
                                          Watch this tutorial video
                                      </a>

                                  </div>

                                  @if ($userWallet)
                                  <button id="updateBtn" type="submit" form="updateWallet" class="submit-button w-100 btn btn-warning mt-4 d-flex flex-column justify-content-center align-items-center">
                                    <div class="spinner-border spinner-border-sm text-dark d-none" role="status">
                                        <span class="sr-only">Loading...</span>
                                    </div>
                                    <span class="btn-text text-dark">Update Address</span>
                                </button>
                                @endif

                                @error('address')
                                <span class="text-danger mb-2">{{ $message }}</span>
                                @enderror
                            </div>
                            @endforeach
                        </form>
                    </div>
                </div>
            </div>
        </div>


            <!-- <div class="card" style="background: #071720;">

                <div class="card-header" style="background: #071720;">

                    <h5>Add/Edit Wallet Address</h5>

                </div>

                <div class="card-body" style="background: #071720;">

                    <form action="{{ route('user.wallet.store') }}" method="POST">

                        @csrf

                        @foreach($walletTypes as $walletType)

                        <div class="">

                            <label for="wallet_type_{{ $walletType->id }}" style="color: white;">{{ $walletType->name }}</label>

                            @php

                            $userWallet = $walletAddresses->firstWhere('type', $walletType->id);

                            @endphp



                            <input type="text" name="address" id="wallet_type_{{ $walletType->id }}" class="form-control"

                                value="{{ $userWallet ? $userWallet->address : '' }}"

                                placeholder="Enter wallet address" required>



                            <input type="hidden" name="wallet_type" value="{{ $walletType->id }}">



                            @if ($userWallet)

                            <button type="submit" class="btn btn-warning mt-2">Update Address</button>

                            @else


                            <button type="submit" class="btn btn-primary mt-2">Add Address</button>

                            @endif



                            @error('address')

                            <span class="text-danger">{{ $message }}</span>

                            @enderror

                        </div>

                        @endforeach

                    </form>

                </div>

            </div> -->
        </div>

    </div>

</div>

@endsection

@push('script')
<script>
    document.addEventListener("DOMContentLoaded", function() {

        document.querySelectorAll('input[name="address[]"]').forEach(function (input) {
            input.addEventListener('input', function () {
                const errorMessage = input.closest('form')?.querySelector('.error-message');
                if (errorMessage) {
                    errorMessage.classList.add('d-none');
                }
            });
        });


        document.querySelectorAll('.submit-button').forEach(function(btn) {

            btn.addEventListener('click', function(e) {
                e.preventDefault();
                var btnId = btn.getAttribute('id');
                btn.querySelector(".spinner-border").classList.remove("d-none");
                btn.querySelector(".btn-text").classList.add("d-none");

                const formId = btn.getAttribute('form');
                const form = document.getElementById(formId);

                if (form) {
                    const addressInput = form.querySelector('[name="address[]"]');
                    const errorMessage = form.querySelector('.error-message');
                    const address = addressInput ? addressInput.value.trim() : '';

                    const regex = /^D{1}[5-9A-HJ-NP-U][1-9A-HJ-NP-Za-km-z]{33}$/;

                    if (!regex.test(address)) {
                        errorMessage.innerHTML = 'Invalid address format <br/> (Eg. D5V8xytPnq75FHrLm6qaV9vcEC5Yh2h8QkV)';
                        errorMessage.classList.remove('d-none');
                        btn.querySelector(".spinner-border").classList.add("d-none");
                        btn.querySelector(".btn-text").classList.remove("d-none");
                        addressInput.focus();
                        return; 
                    }

                    form.submit();
                } else {
                    console.warn('No form found for button:', btn);
                }
            });
        });

    });
</script>
@endpush