<div class="col-12">
    <div class="row g-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header card-header-content-sm-between">
                    <h4 class="card-header-title mb-2 mb-sm-0">{{ __('Plan Purchased') }}
                    </h4>

                    <div class="d-grid d-sm-flex gap-2">
                        <button id="js-daterangepicker-plans-purchased" class="btn btn-white btn-sm dropdown-toggle">
                            <i class="bi-calendar-week"></i>
                            <span class="js-daterangepicker-plans-preview ms-1"></span>
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <canvas id="chartPlansPurchased" height="50"></canvas>
                </div>
            </div>
        </div>

        {{-- Total Users --}}
        @include('admin.partials.dashboard.card', [
        'id' => 'userRecord',
        'route' => route('admin.users'),
        'icon' => 'fa-user',
        'label' => __('Total Users'),
        'valueClass' => 'userRecord-totalUsers',
        'graphId' => 'chartUserRecordsGraph',
        'badgeClass' => 'userRecord-followupGrapClass',
        'badgeValue' => 'userRecord-followupGrap',
        'footerText' => 'userRecord-chartPercentageIncDec'
        ])

        {{-- This Month Transactions --}}
        @include('admin.partials.dashboard.card', [
        'id' => 'transactionRecord',
        'route' => route('admin.transaction'),
        'icon' => 'fa-credit-card',
        'label' => __('This Month Transactions'),
        'valueClass' => 'transactionRecord-totalTransaction',
        'graphId' => 'chartTransactionRecordsGraph',
        'badgeClass' => 'transactionRecord-followupGrapClass',
        'badgeValue' => 'transactionRecord-followupGrap',
        'footerText' => 'transactionRecord-chartPercentageIncDec'
        ])

        {{-- People Have Purchased --}}
        @include('admin.partials.dashboard.card', [
        'id' => 'purchasePeopleRecord',
        'route' => route('admin.users'),
        'icon' => 'fa-users',
        'label' => __('People Have Purchased'),
        'valueClass' => 'purchasePeopleRecord-total',
        'graphId' => 'chartPurchasePeopleRecordsGraph',
        'badgeClass' => 'purchasePeopleRecord-followupGrapClass',
        'badgeValue' => 'purchasePeopleRecord-followupGrap',
        'footerText' => 'purchasePeopleRecord-chartPercentageIncDec'
        ])

        {{-- Units Been Purchased --}}
        @include('admin.partials.dashboard.card', [
        'id' => 'purchaseUnitRecord',
        'route' => route('admin.transaction'),
        'icon' => 'fa-boxes',
        'label' => __('Units Been Purchased'),
        'valueClass' => 'purchaseUnitRecord-total',
        'graphId' => 'chartPurchaseUnitRecordsGraph',
        'badgeClass' => 'purchaseUnitRecord-followupGrapClass',
        'badgeValue' => 'purchaseUnitRecord-followupGrap',
        'footerText' => 'purchaseUnitRecord-chartPercentageIncDec'
        ])
    </div>
</div>

@push('script')
<script>
    const components = [
        {
            id: 'userRecord',
            graphId: 'chartUserRecordsGraph',
            url: "{{ route('admin.chartUserRecords') }}",
            dataMap: {
                total: '.userRecord-totalUsers',
                class: '.userRecord-followupGrapClass',
                value: '.userRecord-followupGrap',
                footer: '.userRecord-chartPercentageIncDec'
            }
        },
        {
            id: 'transactionRecord',
            graphId: 'chartTransactionRecordsGraph',
            url: "{{ route('admin.chartTransactionRecords') }}",
            dataMap: {
                total: '.transactionRecord-totalTransaction',
                class: '.transactionRecord-followupGrapClass',
                value: '.transactionRecord-followupGrap',
                footer: '.transactionRecord-chartPercentageIncDec'
            }
        },
        {
            id: 'purchasePeopleRecord',
            graphId: 'chartPurchasePeopleRecordsGraph',
            url: "{{ route('admin.chartPurchasePeople') }}",
            dataMap: {
                total: '.purchasePeopleRecord-total',
                class: '.purchasePeopleRecord-followupGrapClass',
                value: '.purchasePeopleRecord-followupGrap',
                footer: '.purchasePeopleRecord-chartPercentageIncDec'
            }
        },
        {
            id: 'purchaseUnitRecord',
            graphId: 'chartPurchaseUnitRecordsGraph',
            url: "{{ route('admin.chartPurchaseUnits') }}",
            dataMap: {
                total: '.purchaseUnitRecord-total',
                class: '.purchaseUnitRecord-followupGrapClass',
                value: '.purchaseUnitRecord-followupGrap',
                footer: '.purchaseUnitRecord-chartPercentageIncDec'
            }
        }
    ];

    components.forEach(comp => {
        Notiflix.Block.standard(`#${comp.id}`);
        HSCore.components.HSChartJS.init(document.querySelector(`#${comp.graphId}`), {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    data: [],
                    backgroundColor: ["rgba(55, 125, 255, 0)", "rgba(255, 255, 255, 0)"],
                    borderColor: "#377dff",
                    borderWidth: 2,
                    pointRadius: 0,
                    pointHoverRadius: 0
                }]
            },
            options: {
                scales: { y: { display: false }, x: { display: false } },
                hover: { mode: "nearest", intersect: false },
                plugins: { tooltip: { postfix: "", hasIndicator: true, intersect: false } }
            }
        });

        const chartInstance = HSCore.components.HSChartJS.getItem(comp.graphId);
        axios.get(comp.url).then(res => {
            const dataKey = comp.id;
            const data = res.data[dataKey];

            $(comp.dataMap.total).text(
                data.totalUsers ?? data.totalTransaction ?? data.total ?? data.pendingKYC ?? data.pending ?? 0
                );
            $(comp.dataMap.class).addClass(data.followupGrapClass);
            $(comp.dataMap.value).text(data.followupGrap);
            $(comp.dataMap.footer).text(`from ${data.chartPercentageIncDec}`);

            chartInstance.data.labels = res.data.current_month_data_dates;
            chartInstance.data.datasets[0].data = res.data.current_month_datas;
            chartInstance.update();

            Notiflix.Block.remove(`#${comp.id}`);
        }).catch(() => { });
    });

    function cbPlansPurchased(start, end) {
        $('.js-daterangepicker-plans-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));
    }

    $('#js-daterangepicker-plans-purchased').daterangepicker({
        startDate: moment().startOf('month'),
        endDate: moment().endOf('month'),
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cbPlansPurchased);

    cbPlansPurchased(moment().startOf('month'), moment().endOf('month'));

    let chartPlansPurchased = null;
    function fetchChartPlansPurchased() {
        const picker = $('#js-daterangepicker-plans-purchased').data('daterangepicker');
        const start = picker.startDate.format('YYYY-MM-DD');
        const end = picker.endDate.format('YYYY-MM-DD');

        axios.get("{{ route('admin.chartPlansPurchased') }}", {
            params: {
                start_date: start,
                end_date: end
            }
        }).then(res => {
            const ctx = document.getElementById('chartPlansPurchased').getContext('2d');
            if (chartPlansPurchased !== null) chartPlansPurchased.destroy();

            chartPlansPurchased = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: res.data.labels,
                    datasets: [{
                        label: "Purchases",
                        data: res.data.data,
                        backgroundColor: '#377dff',
                        borderRadius: 8,
                        barThickness: 30
                    }]
                },
                options: {
                    plugins: {
                        legend: { display: false },
                        tooltip: { mode: 'index', intersect: false }
                    },
                    responsive: true,
                    scales: {
                        x: { grid: { display: false }, ticks: { font: { size: 12 } } },
                        y: { grid: { color: '#f1f1f1' }, ticks: { beginAtZero: true } }
                    }
                }
            });
        });
    }

fetchChartPlansPurchased();  // initial load
$('#js-daterangepicker-plans-purchased').on('apply.daterangepicker', fetchChartPlansPurchased);

</script>
@endpush
