@extends('admin.layouts.app')
@section('page_title', __('Edit Configuration'))
@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title">@lang('Edit Monthly Plan')</h1>
            </div>
            <div class="col-sm-auto">
                <a href="{{ route('admin.monthly.general.index') }}" class="btn btn-primary">@lang('Back to List')</a>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <form action="{{ route('admin.monthly.general.update', $config->id) }}" method="post">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title">@lang('Update Configuration')</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Period Start -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="period_start" class="form-label">@lang('Period Start')</label>
                                    <input type="date" 
                                    class="form-control @error('period_start') is-invalid @enderror" 
                                    name="period_start" 
                                    id="period_start" 
                                    value="{{ old('period_start', $config->period_start ? $config->period_start->format('Y-m-d') : '') }}"
                                    required>
                                    @error('period_start')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Period End -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="period_end" class="form-label">@lang('Period End')</label>
                                    <input type="date" 
                                    class="form-control @error('period_end') is-invalid @enderror" 
                                    name="period_end" 
                                    id="period_end" 
                                    value="{{ old('period_end', $config->period_end ? $config->period_end->format('Y-m-d') : '') }}"
                                    required>
                                    @error('period_end')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Reward -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="total_hashrate" class="form-label">@lang('Total Hashrate')</label>
                                    <input type="number" 
                                    step="0.01"
                                    class="form-control @error('total_hashrate') is-invalid @enderror" 
                                    name="total_hashrate" 
                                    id="total_hashrate" 
                                    value="{{ old('total_hashrate', $config->total_hashrate) }}"
                                    required>
                                    @error('total_hashrate')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>           

                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="total_coin_generated" class="form-label">@lang('Total Coin Generated')</label>
                                    <input type="number" 
                                    step="0.0001"
                                    class="form-control @error('total_coin_generated') is-invalid @enderror" 
                                    name="total_coin_generated" 
                                    id="total_coin_generated" 
                                    value="{{ old('total_coin_generated', $config->total_coin_generated) }}"
                                    required>
                                    @error('total_coin_generated')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="total_machine" class="form-label">@lang('Total Machine')</label>
                                    <input type="number" 
                                    step="1" 
                                    class="form-control @error('total_machine') is-invalid @enderror" 
                                    name="total_machine" 
                                    id="total_machine" 
                                    value="{{ old('total_machine', $config->total_machine) }}"
                                    required>
                                    @error('total_machine')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title">@lang('Actions')</h4>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-3">
                            <button type="submit" class="btn btn-primary">@lang('Update')</button>
                            <button type="reset" class="btn btn-secondary">@lang('Reset')</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('script')
<script>
    $(document).ready(function() {
        // Date validation to ensure period_end is after period_start
        $('#period_start, #period_end').change(function() {
            const startDate = new Date($('#period_start').val());
            const endDate = new Date($('#period_end').val());
            
            if (startDate && endDate && endDate < startDate) {
                alert('Period End must be after Period Start');
                $('#period_end').val('');
            }
        });
    });
</script>
@endpush